/*
 * Decompiled with CFR 0.152.
 */
package ru.quipy.query;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import ru.quipy.domain.ActiveEventStreamReader;
import ru.quipy.domain.EventRecord;
import ru.quipy.domain.EventStreamReadIndex;
import ru.quipy.domain.Snapshot;
import ru.quipy.exception.UnknownEntityClassException;
import ru.quipy.query.exception.UnmappedDtoType;
import ru.quipy.query.insert.BatchInsertQuery;
import ru.quipy.query.insert.InsertQuery;
import ru.quipy.query.insert.OnDuplicateKeyUpdateInsertQuery;
import ru.quipy.query.select.SelectQuery;
import ru.quipy.tables.ActiveEventStreamReaderDto;
import ru.quipy.tables.Dto;
import ru.quipy.tables.EventRecordDto;
import ru.quipy.tables.EventRecordTable;
import ru.quipy.tables.EventStreamActiveReadersTable;
import ru.quipy.tables.EventStreamReadIndexDto;
import ru.quipy.tables.EventStreamReadIndexTable;
import ru.quipy.tables.SnapshotDto;
import ru.quipy.tables.SnapshotTable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lru/quipy/query/QueryBuilder;", "", "()V", "Companion", "tiny-postgresql-event-store"})
public final class QueryBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ.\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010J%\u0010\u0011\u001a\u00020\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0019H\u0002J(\u0010!\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u0019H\u0002J\u0018\u0010$\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0019H\u0002J5\u0010%\u001a\u00020 \"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020(H\u0002J(\u0010)\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020(H\u0002J\u0018\u0010*\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020(H\u0002J\u0018\u0010+\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u001eH\u0002J(\u0010,\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u001eH\u0002J\u0018\u0010-\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u001eH\u0002J%\u0010.\u001a\u00020 \"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00101\u001a\u00020(H\u0002J\u0016\u00102\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u00063"}, d2={"Lru/quipy/query/QueryBuilder$Companion;", "", "()V", "batchInsert", "Lru/quipy/query/insert/BatchInsertQuery;", "schema", "", "relation", "dtos", "", "Lru/quipy/tables/EventRecordDto;", "findEntityByIdQuery", "Lru/quipy/query/select/SelectQuery;", "T", "id", "clazz", "Lkotlin/reflect/KClass;", "insert", "Lru/quipy/query/insert/InsertQuery;", "E", "Lru/quipy/tables/Dto;", "entity", "(Ljava/lang/String;Lru/quipy/tables/Dto;)Lru/quipy/query/insert/InsertQuery;", "insertActiveEventStreamReader", "activeStreamReader", "Lru/quipy/tables/ActiveEventStreamReaderDto;", "insertEventRecord", "eventRecord", "insertEventStreamReadIndex", "eventStreamReadIndex", "Lru/quipy/tables/EventStreamReadIndexDto;", "insertOrUpdateActiveStreamReader", "Lru/quipy/query/insert/OnDuplicateKeyUpdateInsertQuery;", "insertOrUpdateActiveStreamReaderByIdAndVersionQuery", "expectedVersion", "", "insertOrUpdateActiveStreamReaderWithLatestVersionQuery", "insertOrUpdateByIdAndVersionQuery", "(Ljava/lang/String;Ljava/lang/Object;JLru/quipy/tables/Dto;)Lru/quipy/query/insert/OnDuplicateKeyUpdateInsertQuery;", "insertOrUpdateSnapshot", "Lru/quipy/tables/SnapshotDto;", "insertOrUpdateSnapshotByIdAndVersionQuery", "insertOrUpdateSnapshotWithLatestVersionQuery", "insertOrUpdateStreamReader", "insertOrUpdateStreamReaderByIdAndVersionQuery", "insertOrUpdateStreamReaderWithLatestVersionQuery", "insertOrUpdateWithLatestVersionQuery", "(Ljava/lang/String;Lru/quipy/tables/Dto;)Lru/quipy/query/insert/OnDuplicateKeyUpdateInsertQuery;", "insertSnapshot", "snapshot", "select", "tiny-postgresql-event-store"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <E extends Dto> InsertQuery insert(@NotNull String schema, @NotNull E entity) {
            InsertQuery insertQuery;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            E e = entity;
            if (e instanceof EventRecordDto) {
                insertQuery = this.insertEventRecord(schema, (EventRecordDto)entity);
            } else if (e instanceof SnapshotDto) {
                insertQuery = this.insertSnapshot(schema, (SnapshotDto)entity);
            } else if (e instanceof ActiveEventStreamReaderDto) {
                insertQuery = this.insertActiveEventStreamReader(schema, (ActiveEventStreamReaderDto)entity);
            } else if (e instanceof EventStreamReadIndexDto) {
                insertQuery = this.insertEventStreamReadIndex(schema, (EventStreamReadIndexDto)entity);
            } else {
                throw new UnmappedDtoType(Reflection.getOrCreateKotlinClass(entity.getClass()).getSimpleName());
            }
            return insertQuery;
        }

        private final InsertQuery insertEventRecord(String schema, EventRecordDto eventRecord) {
            Object[] objectArray = EventRecordTable.Companion.insertColumnNames();
            InsertQuery insertQuery = (InsertQuery)new InsertQuery(schema, "event_record").withColumns(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = eventRecord.values();
            return (InsertQuery)insertQuery.withValues(Arrays.copyOf(objectArray, objectArray.length));
        }

        private final InsertQuery insertSnapshot(String schema, SnapshotDto snapshot) {
            Object[] objectArray = SnapshotTable.Companion.insertColumnNames();
            InsertQuery insertQuery = (InsertQuery)new InsertQuery(schema, "snapshot").withColumns(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = snapshot.values();
            return (InsertQuery)insertQuery.withValues(Arrays.copyOf(objectArray, objectArray.length));
        }

        private final InsertQuery insertActiveEventStreamReader(String schema, ActiveEventStreamReaderDto activeStreamReader) {
            Object[] objectArray = EventStreamActiveReadersTable.Companion.insertColumnNames();
            InsertQuery insertQuery = (InsertQuery)new InsertQuery(schema, "event_stream_active_readers").withColumns(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = activeStreamReader.values();
            return (InsertQuery)insertQuery.withValues(Arrays.copyOf(objectArray, objectArray.length));
        }

        private final InsertQuery insertEventStreamReadIndex(String schema, EventStreamReadIndexDto eventStreamReadIndex) {
            Object[] objectArray = EventStreamReadIndexTable.Companion.insertColumnNames();
            InsertQuery insertQuery = (InsertQuery)new InsertQuery(schema, "event_stream_read_index").withColumns(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = eventStreamReadIndex.values();
            return (InsertQuery)insertQuery.withValues(Arrays.copyOf(objectArray, objectArray.length));
        }

        @NotNull
        public final BatchInsertQuery batchInsert(@NotNull String schema, @NotNull String relation, @NotNull List<EventRecordDto> dtos) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
            Intrinsics.checkNotNullParameter(dtos, (String)"dtos");
            String[] stringArray = EventRecordTable.Companion.insertColumnNames();
            BatchInsertQuery query = (BatchInsertQuery)new BatchInsertQuery(schema, relation).withColumns(Arrays.copyOf(stringArray, stringArray.length));
            Iterable $this$forEach$iv = dtos;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EventRecordDto dto = (EventRecordDto)element$iv;
                boolean bl = false;
                Object[] objectArray = dto.values();
                query.withValues(Arrays.copyOf(objectArray, objectArray.length));
            }
            return query;
        }

        @NotNull
        public final <E extends Dto> OnDuplicateKeyUpdateInsertQuery insertOrUpdateWithLatestVersionQuery(@NotNull String schema, @NotNull E entity) {
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            E e = entity;
            if (e instanceof SnapshotDto) {
                onDuplicateKeyUpdateInsertQuery = this.insertOrUpdateSnapshotWithLatestVersionQuery(schema, (SnapshotDto)entity);
            } else if (e instanceof ActiveEventStreamReaderDto) {
                onDuplicateKeyUpdateInsertQuery = this.insertOrUpdateActiveStreamReaderWithLatestVersionQuery(schema, (ActiveEventStreamReaderDto)entity);
            } else if (e instanceof EventStreamReadIndexDto) {
                onDuplicateKeyUpdateInsertQuery = this.insertOrUpdateStreamReaderWithLatestVersionQuery(schema, (EventStreamReadIndexDto)entity);
            } else {
                throw new UnmappedDtoType(Reflection.getOrCreateKotlinClass(entity.getClass()).getSimpleName());
            }
            return onDuplicateKeyUpdateInsertQuery;
        }

        @NotNull
        public final <E extends Dto> OnDuplicateKeyUpdateInsertQuery insertOrUpdateByIdAndVersionQuery(@NotNull String schema, @NotNull Object id, long expectedVersion, @NotNull E entity) {
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            E e = entity;
            if (e instanceof SnapshotDto) {
                onDuplicateKeyUpdateInsertQuery = this.insertOrUpdateSnapshotByIdAndVersionQuery(schema, id, expectedVersion, (SnapshotDto)entity);
            } else if (e instanceof ActiveEventStreamReaderDto) {
                onDuplicateKeyUpdateInsertQuery = this.insertOrUpdateActiveStreamReaderByIdAndVersionQuery(schema, id, expectedVersion, (ActiveEventStreamReaderDto)entity);
            } else if (e instanceof EventStreamReadIndexDto) {
                onDuplicateKeyUpdateInsertQuery = this.insertOrUpdateStreamReaderByIdAndVersionQuery(schema, id, expectedVersion, (EventStreamReadIndexDto)entity);
            } else {
                throw new UnmappedDtoType(Reflection.getOrCreateKotlinClass(entity.getClass()).getSimpleName());
            }
            return onDuplicateKeyUpdateInsertQuery;
        }

        @NotNull
        public final <T> SelectQuery findEntityByIdQuery(@NotNull String schema, @NotNull Object id, @NotNull KClass<T> clazz) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            KClass<T> kClass = clazz;
            if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(EventRecord.class))) {
                pair = TuplesKt.to((Object)"event_record", (Object)EventRecordTable.Companion.getId().getName());
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Snapshot.class))) {
                pair = TuplesKt.to((Object)"snapshot", (Object)SnapshotTable.Companion.getId().getName());
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(EventStreamReadIndex.class))) {
                pair = TuplesKt.to((Object)"event_stream_read_index", (Object)EventStreamReadIndexTable.Companion.getId().getName());
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(ActiveEventStreamReader.class))) {
                pair = TuplesKt.to((Object)"event_stream_active_readers", (Object)EventStreamActiveReadersTable.Companion.getId().getName());
            } else {
                throw new UnknownEntityClassException(clazz.getSimpleName());
            }
            Pair pair2 = pair;
            String tableName = (String)pair2.component1();
            String tableIdColumnName = (String)pair2.component2();
            return ((SelectQuery)this.select(schema, tableName).andWhere(tableName + '.' + tableIdColumnName + " = '" + id + '\'')).limit(1);
        }

        private final OnDuplicateKeyUpdateInsertQuery insertOrUpdateSnapshot(String schema, SnapshotDto entity) {
            Object[] objectArray = SnapshotTable.Companion.insertColumnNames();
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery = (OnDuplicateKeyUpdateInsertQuery)new OnDuplicateKeyUpdateInsertQuery(schema, "snapshot").withColumns(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = entity.values();
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery2 = (OnDuplicateKeyUpdateInsertQuery)onDuplicateKeyUpdateInsertQuery.withValues(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = new String[]{SnapshotTable.Companion.getId().getName()};
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery3 = onDuplicateKeyUpdateInsertQuery2.withPossiblyConflictingColumns((String[])objectArray);
            objectArray = SnapshotTable.Companion.onDuplicateKeyUpdateFields();
            return onDuplicateKeyUpdateInsertQuery3.onDuplicateKeyUpdateColumns((String[])Arrays.copyOf(objectArray, objectArray.length));
        }

        private final OnDuplicateKeyUpdateInsertQuery insertOrUpdateActiveStreamReader(String schema, ActiveEventStreamReaderDto entity) {
            Object[] objectArray = EventStreamActiveReadersTable.Companion.insertColumnNames();
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery = (OnDuplicateKeyUpdateInsertQuery)new OnDuplicateKeyUpdateInsertQuery(schema, "event_stream_active_readers").withColumns(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = entity.values();
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery2 = (OnDuplicateKeyUpdateInsertQuery)onDuplicateKeyUpdateInsertQuery.withValues(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = new String[]{EventStreamActiveReadersTable.Companion.getId().getName()};
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery3 = onDuplicateKeyUpdateInsertQuery2.withPossiblyConflictingColumns((String[])objectArray);
            objectArray = EventStreamActiveReadersTable.Companion.onDuplicateKeyUpdateFields();
            return onDuplicateKeyUpdateInsertQuery3.onDuplicateKeyUpdateColumns((String[])Arrays.copyOf(objectArray, objectArray.length));
        }

        private final OnDuplicateKeyUpdateInsertQuery insertOrUpdateStreamReader(String schema, EventStreamReadIndexDto entity) {
            Object[] objectArray = EventStreamReadIndexTable.Companion.insertColumnNames();
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery = (OnDuplicateKeyUpdateInsertQuery)new OnDuplicateKeyUpdateInsertQuery(schema, "event_stream_read_index").withColumns(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = entity.values();
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery2 = (OnDuplicateKeyUpdateInsertQuery)onDuplicateKeyUpdateInsertQuery.withValues(Arrays.copyOf(objectArray, objectArray.length));
            objectArray = new String[]{EventStreamReadIndexTable.Companion.getId().getName()};
            OnDuplicateKeyUpdateInsertQuery onDuplicateKeyUpdateInsertQuery3 = onDuplicateKeyUpdateInsertQuery2.withPossiblyConflictingColumns((String[])objectArray);
            objectArray = EventStreamReadIndexTable.Companion.onDuplicateKeyUpdateFields();
            return onDuplicateKeyUpdateInsertQuery3.onDuplicateKeyUpdateColumns((String[])Arrays.copyOf(objectArray, objectArray.length));
        }

        private final OnDuplicateKeyUpdateInsertQuery insertOrUpdateSnapshotWithLatestVersionQuery(String schema, SnapshotDto entity) {
            return (OnDuplicateKeyUpdateInsertQuery)this.insertOrUpdateSnapshot(schema, entity).andWhere("snapshot." + SnapshotTable.Companion.getVersion().getName() + " < " + entity.getVersion());
        }

        private final OnDuplicateKeyUpdateInsertQuery insertOrUpdateActiveStreamReaderWithLatestVersionQuery(String schema, ActiveEventStreamReaderDto entity) {
            return (OnDuplicateKeyUpdateInsertQuery)this.insertOrUpdateActiveStreamReader(schema, entity).andWhere("event_stream_active_readers." + EventStreamActiveReadersTable.Companion.getVersion().getName() + " = " + (entity.getVersion() - 1L));
        }

        private final OnDuplicateKeyUpdateInsertQuery insertOrUpdateStreamReaderWithLatestVersionQuery(String schema, EventStreamReadIndexDto entity) {
            return (OnDuplicateKeyUpdateInsertQuery)this.insertOrUpdateStreamReader(schema, entity).andWhere("event_stream_read_index." + EventStreamReadIndexTable.Companion.getVersion().getName() + " < " + entity.getVersion());
        }

        private final OnDuplicateKeyUpdateInsertQuery insertOrUpdateSnapshotByIdAndVersionQuery(String schema, Object id, long expectedVersion, SnapshotDto entity) {
            return (OnDuplicateKeyUpdateInsertQuery)((OnDuplicateKeyUpdateInsertQuery)this.insertOrUpdateSnapshot(schema, entity).andWhere("snapshot." + SnapshotTable.Companion.getId().getName() + " = '" + id + '\'')).andWhere("snapshot." + SnapshotTable.Companion.getVersion().getName() + " = " + expectedVersion);
        }

        private final OnDuplicateKeyUpdateInsertQuery insertOrUpdateStreamReaderByIdAndVersionQuery(String schema, Object id, long expectedVersion, EventStreamReadIndexDto entity) {
            return (OnDuplicateKeyUpdateInsertQuery)((OnDuplicateKeyUpdateInsertQuery)this.insertOrUpdateStreamReader(schema, entity).andWhere("event_stream_read_index." + EventStreamReadIndexTable.Companion.getId().getName() + " = '" + id + '\'')).andWhere("event_stream_read_index." + EventStreamReadIndexTable.Companion.getVersion().getName() + " = " + expectedVersion);
        }

        private final OnDuplicateKeyUpdateInsertQuery insertOrUpdateActiveStreamReaderByIdAndVersionQuery(String schema, Object id, long expectedVersion, ActiveEventStreamReaderDto entity) {
            return (OnDuplicateKeyUpdateInsertQuery)((OnDuplicateKeyUpdateInsertQuery)this.insertOrUpdateActiveStreamReader(schema, entity).andWhere("event_stream_active_readers." + EventStreamActiveReadersTable.Companion.getId().getName() + " = '" + id + '\'')).andWhere("event_stream_active_readers." + EventStreamActiveReadersTable.Companion.getVersion().getName() + " = " + expectedVersion);
        }

        @NotNull
        public final SelectQuery select(@NotNull String schema, @NotNull String relation) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
            return new SelectQuery(schema, relation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

