/*
 * Decompiled with CFR 0.152.
 */
package ru.quipy.query;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.quipy.query.Query;
import ru.quipy.query.exception.InvalidQueryStateException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0017H\u0004J\u000b\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0014J!\u0010\"\u001a\u00028\u00002\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040#\"\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u00028\u00002\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170#\"\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010&R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\n\u00a8\u0006'"}, d2={"Lru/quipy/query/BasicQuery;", "T", "Lru/quipy/query/Query;", "schema", "", "relation", "(Ljava/lang/String;Ljava/lang/String;)V", "columns", "", "getColumns", "()Ljava/util/List;", "conditions", "getConditions", "getRelation", "()Ljava/lang/String;", "returnEntity", "", "getReturnEntity", "()Z", "setReturnEntity", "(Z)V", "getSchema", "values", "", "getValues", "andWhere", "condition", "(Ljava/lang/String;)Lru/quipy/query/Query;", "convertValueToString", "value", "returningEntity", "()Lru/quipy/query/Query;", "validate", "", "withColumns", "", "([Ljava/lang/String;)Lru/quipy/query/Query;", "withValues", "([Ljava/lang/Object;)Lru/quipy/query/Query;", "tiny-postgresql-event-store"})
public abstract class BasicQuery<T extends Query>
implements Query {
    @NotNull
    private final String schema;
    @NotNull
    private final String relation;
    @NotNull
    private final List<String> columns;
    @NotNull
    private final List<Object> values;
    @NotNull
    private final List<String> conditions;
    private boolean returnEntity;

    public BasicQuery(@NotNull String schema, @NotNull String relation) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        this.schema = schema;
        this.relation = relation;
        this.columns = new ArrayList();
        this.values = new ArrayList();
        this.conditions = new ArrayList();
    }

    @NotNull
    protected final String getSchema() {
        return this.schema;
    }

    @NotNull
    protected final String getRelation() {
        return this.relation;
    }

    @NotNull
    protected final List<String> getColumns() {
        return this.columns;
    }

    @NotNull
    protected final List<Object> getValues() {
        return this.values;
    }

    @NotNull
    protected final List<String> getConditions() {
        return this.conditions;
    }

    protected final boolean getReturnEntity() {
        return this.returnEntity;
    }

    protected final void setReturnEntity(boolean bl) {
        this.returnEntity = bl;
    }

    @NotNull
    public T withColumns(String ... columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        this.columns.clear();
        for (String t : columns) {
            this.columns.add(t);
        }
        return (T)this;
    }

    @NotNull
    public T withValues(Object ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.values.clear();
        for (Object t : values) {
            this.values.add(t);
        }
        return (T)this;
    }

    @NotNull
    public final T andWhere(@NotNull String condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.conditions.add(condition);
        return (T)this;
    }

    @NotNull
    public final T returningEntity() {
        this.returnEntity = true;
        return (T)this;
    }

    protected void validate() {
        if (this.columns.size() != this.values.size()) {
            throw new InvalidQueryStateException("Columns size doesn't match values size\ncolumns[" + CollectionsKt.joinToString$default((Iterable)this.columns, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]\nvalues[" + CollectionsKt.joinToString$default((Iterable)this.values, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ']');
        }
    }

    @NotNull
    protected final String convertValueToString(@NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Long) {
            string = value.toString();
        } else if (object instanceof String) {
            string = "" + '\'' + value + '\'';
        } else {
            throw new Exception("Unknown type");
        }
        return string;
    }
}

