/*
 * Decompiled with CFR 0.152.
 */
package ru.quipy.executor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import ru.quipy.db.factory.ConnectionFactory;
import ru.quipy.executor.QueryExecutor;
import ru.quipy.query.BasicQuery;
import ru.quipy.query.Query;
import ru.quipy.query.insert.BatchInsertQuery;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016JE\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\t*\u00020\n\"\u0004\b\u0001\u0010\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0016\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016J \u0010\u0016\u001a\u00020\u0017\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lru/quipy/executor/ExceptionLoggingSqlQueriesExecutor;", "Lru/quipy/executor/QueryExecutor;", "connectionFactory", "Lru/quipy/db/factory/ConnectionFactory;", "logger", "Lorg/slf4j/Logger;", "(Lru/quipy/db/factory/ConnectionFactory;Lorg/slf4j/Logger;)V", "execute", "", "T", "Lru/quipy/query/Query;", "query", "Lru/quipy/query/BasicQuery;", "executeAndProcessResultSet", "E", "processFunction", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "(Lru/quipy/query/BasicQuery;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "executeBatchInsert", "Lru/quipy/query/insert/BatchInsertQuery;", "executeDependingOnQueryType", "executeReturningBoolean", "", "tiny-postgresql-event-store"})
public class ExceptionLoggingSqlQueriesExecutor
implements QueryExecutor {
    @NotNull
    private final ConnectionFactory connectionFactory;
    @NotNull
    private final Logger logger;

    public ExceptionLoggingSqlQueriesExecutor(@NotNull ConnectionFactory connectionFactory, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.connectionFactory = connectionFactory;
        this.logger = logger;
    }

    @Override
    public <T extends Query> boolean executeReturningBoolean(@NotNull BasicQuery<T> query) {
        boolean bl;
        Intrinsics.checkNotNullParameter(query, (String)"query");
        try {
            this.executeDependingOnQueryType(query);
            bl = true;
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage());
            bl = false;
        }
        return bl;
    }

    @Override
    public <T extends Query> void execute(@NotNull BasicQuery<T> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        this.executeDependingOnQueryType(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T extends Query, E> E executeAndProcessResultSet(@NotNull BasicQuery<T> query, @NotNull Function1<? super ResultSet, ? extends E> processFunction) {
        Object object;
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(processFunction, (String)"processFunction");
        if (query instanceof BatchInsertQuery) {
            throw new UnsupportedOperationException("Cannot return result set executing batch insert");
        }
        AutoCloseable autoCloseable = this.connectionFactory.getDatabaseConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            object = processFunction.invoke((Object)connection.prepareStatement(query.build()).executeQuery());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Query> void executeDependingOnQueryType(@NotNull BasicQuery<T> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        if (query instanceof BatchInsertQuery) {
            this.executeBatchInsert((BatchInsertQuery)query);
        } else {
            AutoCloseable autoCloseable = this.connectionFactory.getDatabaseConnection();
            Throwable throwable = null;
            try {
                Connection connection = (Connection)autoCloseable;
                boolean bl = false;
                boolean bl2 = connection.prepareStatement(query.build()).execute();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatchInsert(@NotNull BatchInsertQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        List sqls = null;
        Object object = new String[]{"\n"};
        sqls = StringsKt.split$default((CharSequence)query.build(), (String[])object, (boolean)false, (int)0, (int)6, null);
        object = this.connectionFactory.getDatabaseConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)object;
            boolean bl = false;
            Statement prepared = connection.createStatement();
            for (String sql2 : sqls) {
                prepared.addBatch(sql2);
            }
            int[] nArray = prepared.executeBatch();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }
}

