/*
 * Decompiled with CFR 0.152.
 */
package ru.quipy.converter;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.quipy.converter.EntityConverter;
import ru.quipy.converter.ResultSetToEntityMapper;
import ru.quipy.converter.exception.NoMapperForClass;
import ru.quipy.domain.ActiveEventStreamReader;
import ru.quipy.domain.EventRecord;
import ru.quipy.domain.EventStreamReadIndex;
import ru.quipy.domain.Snapshot;
import ru.quipy.domain.Unique;
import ru.quipy.saga.SagaContext;
import ru.quipy.tables.EventRecordTable;
import ru.quipy.tables.EventStreamActiveReadersTable;
import ru.quipy.tables.EventStreamReadIndexTable;
import ru.quipy.tables.SnapshotTable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J9\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0010\"\b\b\u0000\u0010\u0006*\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/quipy/converter/ResultSetToEntityMapperImpl;", "Lru/quipy/converter/ResultSetToEntityMapper;", "entityConverter", "Lru/quipy/converter/EntityConverter;", "(Lru/quipy/converter/EntityConverter;)V", "convert", "T", "", "resultSet", "Ljava/sql/ResultSet;", "clazz", "Lkotlin/reflect/KClass;", "scroll", "", "(Ljava/sql/ResultSet;Lkotlin/reflect/KClass;Z)Ljava/lang/Object;", "convertMany", "", "mapToActiveEventStreamReader", "Lru/quipy/domain/ActiveEventStreamReader;", "mapToEventRecord", "Lru/quipy/domain/EventRecord;", "mapToEventStreamReader", "Lru/quipy/domain/EventStreamReadIndex;", "mapToSnapshot", "Lru/quipy/domain/Snapshot;", "tiny-postgresql-event-store"})
public final class ResultSetToEntityMapperImpl
implements ResultSetToEntityMapper {
    @NotNull
    private final EntityConverter entityConverter;

    public ResultSetToEntityMapperImpl(@NotNull EntityConverter entityConverter) {
        Intrinsics.checkNotNullParameter((Object)entityConverter, (String)"entityConverter");
        this.entityConverter = entityConverter;
    }

    @Override
    @Nullable
    public <T> T convert(@Nullable ResultSet resultSet, @NotNull KClass<T> clazz, boolean scroll) {
        Unique unique;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (resultSet == null) {
            return null;
        }
        if (scroll && !resultSet.next()) {
            return null;
        }
        KClass<T> kClass = clazz;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(EventRecord.class))) {
            unique = (Unique)this.mapToEventRecord(resultSet);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Snapshot.class))) {
            unique = (Unique)this.mapToSnapshot(resultSet);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(EventStreamReadIndex.class))) {
            unique = (Unique)this.mapToEventStreamReader(resultSet);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(ActiveEventStreamReader.class))) {
            unique = (Unique)this.mapToActiveEventStreamReader(resultSet);
        } else {
            throw new NoMapperForClass(clazz.getSimpleName());
        }
        return (T)unique;
    }

    @Override
    @NotNull
    public <T> List<T> convertMany(@Nullable ResultSet resultSet, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (resultSet == null) {
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        Object res = null;
        do {
            if ((res = ResultSetToEntityMapper.DefaultImpls.convert$default(this, resultSet, clazz, false, 4, null)) == null) continue;
            result.add(res);
        } while (res != null);
        return result;
    }

    private final EventRecord mapToEventRecord(ResultSet resultSet) {
        String string = resultSet.getString(EventRecordTable.Companion.getId().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultSet.getString(EventRecordTable.id.index)");
        String string2 = resultSet.getString(EventRecordTable.Companion.getAggregateId().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resultSet.getString(Even\u2026dTable.aggregateId.index)");
        long l = resultSet.getLong(EventRecordTable.Companion.getAggregateVersion().getIndex());
        String string3 = resultSet.getString(EventRecordTable.Companion.getEventTitle().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resultSet.getString(Even\u2026rdTable.eventTitle.index)");
        String string4 = resultSet.getString(EventRecordTable.Companion.getPayload().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resultSet.getString(Even\u2026ecordTable.payload.index)");
        String string5 = resultSet.getString(EventRecordTable.Companion.getSagaContext().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"resultSet.getString(Even\u2026dTable.sagaContext.index)");
        return new EventRecord(string, (Object)string2, l, string3, string4, (SagaContext)this.entityConverter.toNullableObject(string5, Reflection.getOrCreateKotlinClass(SagaContext.class)), resultSet.getLong(EventRecordTable.Companion.getCreatedAt().getIndex()));
    }

    private final Snapshot mapToSnapshot(ResultSet resultSet) {
        String string = resultSet.getString(SnapshotTable.Companion.getId().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultSet.getString(SnapshotTable.id.index)");
        String string2 = resultSet.getString(SnapshotTable.Companion.getSnapshot().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resultSet.getString(SnapshotTable.snapshot.index)");
        Class<?> clazz = Class.forName(resultSet.getString(SnapshotTable.Companion.getAggregateStateClassName().getIndex()));
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(resultSet.getStr\u2026ateStateClassName.index))");
        Object t = this.entityConverter.toObject(string2, JvmClassMappingKt.getKotlinClass(clazz));
        Intrinsics.checkNotNullExpressionValue(t, (String)"entityConverter.toObject\u2026ClassName.index)).kotlin)");
        return new Snapshot((Object)string, t, resultSet.getLong(SnapshotTable.Companion.getVersion().getIndex()));
    }

    private final EventStreamReadIndex mapToEventStreamReader(ResultSet resultSet) {
        String string = resultSet.getString(EventStreamReadIndexTable.Companion.getId().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultSet.getString(Even\u2026mReadIndexTable.id.index)");
        return new EventStreamReadIndex(string, resultSet.getLong(EventStreamReadIndexTable.Companion.getReadIndex().getIndex()), resultSet.getLong(EventStreamReadIndexTable.Companion.getVersion().getIndex()));
    }

    private final ActiveEventStreamReader mapToActiveEventStreamReader(ResultSet resultSet) {
        String string = resultSet.getString(EventStreamActiveReadersTable.Companion.getId().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultSet.getString(Even\u2026iveReadersTable.id.index)");
        long l = resultSet.getLong(EventStreamActiveReadersTable.Companion.getVersion().getIndex());
        String string2 = resultSet.getString(EventStreamActiveReadersTable.Companion.getReaderId().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resultSet.getString(Even\u2026dersTable.readerId.index)");
        return new ActiveEventStreamReader(string, l, string2, resultSet.getLong(EventStreamActiveReadersTable.Companion.getReadPosition().getIndex()), resultSet.getLong(EventStreamActiveReadersTable.Companion.getLastInteraction().getIndex()));
    }
}

