/*
 * Decompiled with CFR 0.152.
 */
package ru.quipy.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.quipy.converter.EntityConverter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u0002H\u0007H\u0016\u00a2\u0006\u0002\u0010\nJ/\u0010\u000b\u001a\u0004\u0018\u0001H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/quipy/converter/JsonEntityConverter;", "Lru/quipy/converter/EntityConverter;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "serialize", "", "T", "", "obj", "(Ljava/lang/Object;)Ljava/lang/String;", "toNullableObject", "converted", "clazz", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "toObject", "tiny-postgresql-event-store"})
public final class JsonEntityConverter
implements EntityConverter {
    @NotNull
    private final ObjectMapper objectMapper;

    public JsonEntityConverter(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.objectMapper = objectMapper;
    }

    @Override
    @NotNull
    public <T> String serialize(@NotNull T obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        String string = this.objectMapper.writeValueAsString(obj);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectMapper.writeValueAsString(obj)");
        return string;
    }

    @Override
    @NotNull
    public <T> T toObject(@NotNull String converted, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)converted, (String)"converted");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = this.objectMapper.readValue(converted, JvmClassMappingKt.getJavaClass(clazz));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.readValue(converted, clazz.java)");
        return (T)object;
    }

    @Override
    @Nullable
    public <T> T toNullableObject(@NotNull String converted, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)converted, (String)"converted");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)this.objectMapper.readValue(converted, JvmClassMappingKt.getJavaClass(clazz));
    }
}

