/*
 * Decompiled with CFR 0.152.
 */
package ru.quipy;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;
import ru.quipy.converter.EntityConverter;
import ru.quipy.converter.ResultSetToEntityMapper;
import ru.quipy.core.exceptions.DuplicateEventIdException;
import ru.quipy.database.EventStore;
import ru.quipy.domain.ActiveEventStreamReader;
import ru.quipy.domain.EventRecord;
import ru.quipy.domain.EventStreamReadIndex;
import ru.quipy.domain.Snapshot;
import ru.quipy.domain.Unique;
import ru.quipy.domain.Versioned;
import ru.quipy.executor.QueryExecutor;
import ru.quipy.query.QueryBuilder;
import ru.quipy.query.insert.InsertQuery;
import ru.quipy.query.insert.OnDuplicateKeyUpdateInsertQuery;
import ru.quipy.query.select.SelectQuery;
import ru.quipy.tables.ActiveEventStreamReaderDto;
import ru.quipy.tables.Dto;
import ru.quipy.tables.DtoCreator;
import ru.quipy.tables.EventRecordDto;
import ru.quipy.tables.EventRecordTable;
import ru.quipy.tables.EventStreamReadIndexDto;
import ru.quipy.tables.SnapshotDto;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J/\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0014H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0011H\u0016J\u001e\u0010+\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0017J\u0010\u0010-\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020'H\u0016J7\u00101\u001a\u00020\f\"\u0010\b\u0000\u00102*\u000203*\u0006\u0012\u0002\b\u0003042\u0006\u00105\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00142\u0006\u00106\u001a\u0002H2H\u0002\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020'H\u0016J\u0018\u0010:\u001a\u00020)2\u0006\u00105\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lru/quipy/PostgresClientEventStore;", "Lru/quipy/database/EventStore;", "eventStoreSchemaName", "", "resultSetToEntityMapper", "Lru/quipy/converter/ResultSetToEntityMapper;", "entityConverter", "Lru/quipy/converter/EntityConverter;", "executor", "Lru/quipy/executor/QueryExecutor;", "(Ljava/lang/String;Lru/quipy/converter/ResultSetToEntityMapper;Lru/quipy/converter/EntityConverter;Lru/quipy/executor/QueryExecutor;)V", "commitStreamReadIndex", "", "readIndex", "Lru/quipy/domain/EventStreamReadIndex;", "findBatchOfEventRecordAfter", "", "Lru/quipy/domain/EventRecord;", "aggregateTableName", "eventSequenceNum", "", "batchSize", "", "findEntityById", "T", "", "id", "clazz", "Lkotlin/reflect/KClass;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "findEventRecordsWithAggregateVersionGraterThan", "aggregateId", "aggregateVersion", "findSnapshotByAggregateId", "Lru/quipy/domain/Snapshot;", "snapshotsTableName", "findStreamReadIndex", "streamName", "getActiveStreamReader", "Lru/quipy/domain/ActiveEventStreamReader;", "insertEventRecord", "", "eventRecord", "insertEventRecords", "eventRecords", "tableExists", "tryReplaceActiveStreamReader", "expectedVersion", "newActiveReader", "tryReplaceWithOptimisticLock", "E", "Lru/quipy/domain/Versioned;", "Lru/quipy/domain/Unique;", "tableName", "entity", "(Ljava/lang/String;JLru/quipy/domain/Versioned;)Z", "tryUpdateActiveStreamReader", "updatedActiveReader", "updateSnapshotWithLatestVersion", "snapshot", "Companion", "tiny-postgresql-event-store"})
public class PostgresClientEventStore
implements EventStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String eventStoreSchemaName;
    @NotNull
    private final ResultSetToEntityMapper resultSetToEntityMapper;
    @NotNull
    private final EntityConverter entityConverter;
    @NotNull
    private final QueryExecutor executor;
    @NotNull
    private static final Logger logger;

    public PostgresClientEventStore(@NotNull String eventStoreSchemaName, @NotNull ResultSetToEntityMapper resultSetToEntityMapper, @NotNull EntityConverter entityConverter, @NotNull QueryExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)eventStoreSchemaName, (String)"eventStoreSchemaName");
        Intrinsics.checkNotNullParameter((Object)resultSetToEntityMapper, (String)"resultSetToEntityMapper");
        Intrinsics.checkNotNullParameter((Object)entityConverter, (String)"entityConverter");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.eventStoreSchemaName = eventStoreSchemaName;
        this.resultSetToEntityMapper = resultSetToEntityMapper;
        this.entityConverter = entityConverter;
        this.executor = executor;
    }

    public void insertEventRecord(@NotNull String aggregateTableName, @NotNull EventRecord eventRecord) {
        Intrinsics.checkNotNullParameter((Object)aggregateTableName, (String)"aggregateTableName");
        Intrinsics.checkNotNullParameter((Object)eventRecord, (String)"eventRecord");
        try {
            this.executor.execute(QueryBuilder.Companion.insert(this.eventStoreSchemaName, (Dto)new EventRecordDto(eventRecord, aggregateTableName, this.entityConverter)));
        }
        catch (DuplicateKeyException e) {
            throw new DuplicateEventIdException("There is record with such an id. Record cannot be saved " + eventRecord, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void insertEventRecords(@NotNull String aggregateTableName, @NotNull List<EventRecord> eventRecords) {
        Intrinsics.checkNotNullParameter((Object)aggregateTableName, (String)"aggregateTableName");
        Intrinsics.checkNotNullParameter(eventRecords, (String)"eventRecords");
        try {
            Collection<EventRecordDto> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = eventRecords;
            String string = "event_record";
            String string2 = this.eventStoreSchemaName;
            QueryBuilder.Companion companion = QueryBuilder.Companion;
            QueryExecutor queryExecutor = this.executor;
            boolean $i$f$map = false;
            void var5_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EventRecord eventRecord = (EventRecord)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EventRecordDto((EventRecord)it, aggregateTableName, this.entityConverter));
            }
            collection = (List)destination$iv$iv;
            queryExecutor.execute(companion.batchInsert(string2, string, (List<EventRecordDto>)collection));
        }
        catch (DuplicateKeyException e) {
            throw new DuplicateEventIdException("There is record with such an id. Record set cannot be saved " + eventRecords, (Throwable)e);
        }
    }

    public boolean tableExists(@NotNull String aggregateTableName) {
        Intrinsics.checkNotNullParameter((Object)aggregateTableName, (String)"aggregateTableName");
        return true;
    }

    public void updateSnapshotWithLatestVersion(@NotNull String tableName, @NotNull Snapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.executor.execute(QueryBuilder.Companion.insertOrUpdateWithLatestVersionQuery(this.eventStoreSchemaName, (Dto)new SnapshotDto(snapshot, tableName, this.entityConverter)));
    }

    @NotNull
    public List<EventRecord> findEventRecordsWithAggregateVersionGraterThan(@NotNull String aggregateTableName, @NotNull Object aggregateId, long aggregateVersion) {
        Intrinsics.checkNotNullParameter((Object)aggregateTableName, (String)"aggregateTableName");
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        SelectQuery query = (SelectQuery)((SelectQuery)((SelectQuery)QueryBuilder.Companion.select(this.eventStoreSchemaName, "event_record").andWhere(EventRecordTable.Companion.getAggregateId().getName() + " = '" + aggregateId + '\'')).andWhere(EventRecordTable.Companion.getAggregateTableName().getName() + " = '" + aggregateTableName + '\'')).andWhere(EventRecordTable.Companion.getAggregateVersion().getName() + " > " + aggregateVersion);
        List list = (List)this.executor.executeAndProcessResultSet(query, (Function1)new Function1<ResultSet, List<? extends EventRecord>>(this){
            final /* synthetic */ PostgresClientEventStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final List<EventRecord> invoke(@Nullable ResultSet it) {
                return PostgresClientEventStore.access$getResultSetToEntityMapper$p(this.this$0).convertMany(it, Reflection.getOrCreateKotlinClass(EventRecord.class));
            }
        });
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public List<EventRecord> findBatchOfEventRecordAfter(@NotNull String aggregateTableName, long eventSequenceNum, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)aggregateTableName, (String)"aggregateTableName");
        SelectQuery query = ((SelectQuery)((SelectQuery)QueryBuilder.Companion.select(this.eventStoreSchemaName, "event_record").andWhere(EventRecordTable.Companion.getAggregateTableName().getName() + " = '" + aggregateTableName + '\'')).andWhere(EventRecordTable.Companion.getCreatedAt().getName() + " > " + eventSequenceNum)).orderBy(EventRecordTable.Companion.getCreatedAt().getName(), SelectQuery.SortingOrder.ASCENDING).limit(batchSize);
        List list = (List)this.executor.executeAndProcessResultSet(query, (Function1)new Function1<ResultSet, List<? extends EventRecord>>(this){
            final /* synthetic */ PostgresClientEventStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final List<EventRecord> invoke(@Nullable ResultSet it) {
                return PostgresClientEventStore.access$getResultSetToEntityMapper$p(this.this$0).convertMany(it, Reflection.getOrCreateKotlinClass(EventRecord.class));
            }
        });
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public Snapshot findSnapshotByAggregateId(@NotNull String snapshotsTableName, @NotNull Object aggregateId) {
        Intrinsics.checkNotNullParameter((Object)snapshotsTableName, (String)"snapshotsTableName");
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        return (Snapshot)this.findEntityById(aggregateId, Reflection.getOrCreateKotlinClass(Snapshot.class));
    }

    @Nullable
    public EventStreamReadIndex findStreamReadIndex(@NotNull String streamName) {
        Intrinsics.checkNotNullParameter((Object)streamName, (String)"streamName");
        return (EventStreamReadIndex)this.findEntityById(streamName, Reflection.getOrCreateKotlinClass(EventStreamReadIndex.class));
    }

    @Nullable
    public ActiveEventStreamReader getActiveStreamReader(@NotNull String streamName) {
        Intrinsics.checkNotNullParameter((Object)streamName, (String)"streamName");
        return (ActiveEventStreamReader)this.findEntityById(streamName, Reflection.getOrCreateKotlinClass(ActiveEventStreamReader.class));
    }

    public boolean tryUpdateActiveStreamReader(@NotNull ActiveEventStreamReader updatedActiveReader) {
        Intrinsics.checkNotNullParameter((Object)updatedActiveReader, (String)"updatedActiveReader");
        return this.executor.executeReturningBoolean(QueryBuilder.Companion.insertOrUpdateByIdAndVersionQuery(this.eventStoreSchemaName, updatedActiveReader.getId(), updatedActiveReader.getVersion() - 1L, (Dto)new ActiveEventStreamReaderDto(updatedActiveReader)));
    }

    public boolean tryReplaceActiveStreamReader(long expectedVersion, @NotNull ActiveEventStreamReader newActiveReader) {
        Intrinsics.checkNotNullParameter((Object)newActiveReader, (String)"newActiveReader");
        return this.tryReplaceWithOptimisticLock("event_stream_active_readers", expectedVersion, (Versioned)newActiveReader);
    }

    public boolean commitStreamReadIndex(@NotNull EventStreamReadIndex readIndex) {
        Intrinsics.checkNotNullParameter((Object)readIndex, (String)"readIndex");
        return this.executor.executeReturningBoolean(QueryBuilder.Companion.insertOrUpdateWithLatestVersionQuery(this.eventStoreSchemaName, (Dto)new EventStreamReadIndexDto(readIndex)));
    }

    private final <T> T findEntityById(Object id, KClass<T> clazz) {
        SelectQuery query = QueryBuilder.Companion.findEntityByIdQuery(this.eventStoreSchemaName, id, clazz);
        return (T)this.executor.executeAndProcessResultSet(query, (Function1)new Function1<ResultSet, T>(this, clazz){
            final /* synthetic */ PostgresClientEventStore this$0;
            final /* synthetic */ KClass<T> $clazz;
            {
                this.this$0 = $receiver;
                this.$clazz = $clazz;
                super(1);
            }

            @Nullable
            public final T invoke(@Nullable ResultSet rs) {
                return (T)ResultSetToEntityMapper.DefaultImpls.convert$default(PostgresClientEventStore.access$getResultSetToEntityMapper$p(this.this$0), rs, this.$clazz, false, 4, null);
            }
        });
    }

    private final <E extends Versioned & Unique<?>> boolean tryReplaceWithOptimisticLock(String tableName, long expectedVersion, E entity) {
        boolean bl;
        block4: {
            boolean bl2;
            while (true) {
                Object object = ((Unique<?>)entity).getId();
                Intrinsics.checkNotNull((Object)object);
                Versioned existingEntity = (Versioned)this.findEntityById(object, Reflection.getOrCreateKotlinClass(entity.getClass()));
                if (existingEntity != null) {
                    Object object2 = ((Unique<?>)entity).getId();
                    Intrinsics.checkNotNull((Object)object2);
                    OnDuplicateKeyUpdateInsertQuery query = QueryBuilder.Companion.insertOrUpdateByIdAndVersionQuery(this.eventStoreSchemaName, object2, expectedVersion, DtoCreator.Companion.create(entity, tableName, this.entityConverter));
                    bl = this.executor.executeReturningBoolean(query);
                    break block4;
                }
                try {
                    InsertQuery query = QueryBuilder.Companion.insert(this.eventStoreSchemaName, DtoCreator.Companion.create(entity, tableName, this.entityConverter));
                    this.executor.execute(query);
                    bl2 = true;
                }
                catch (PSQLException e) {
                    logger.info("Entity concurrent update led to clashing. Entity: " + entity + ", table name: " + tableName, (Throwable)e);
                    continue;
                }
                break;
            }
            bl = bl2;
        }
        return bl;
    }

    public static final /* synthetic */ ResultSetToEntityMapper access$getResultSetToEntityMapper$p(PostgresClientEventStore $this) {
        return $this.resultSetToEntityMapper;
    }

    static {
        Logger logger = LoggerFactory.getLogger(PostgresClientEventStore.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PostgresClientEventStore::class.java)");
        PostgresClientEventStore.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lru/quipy/PostgresClientEventStore$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "tiny-postgresql-event-store"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

