/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.socket.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySocket
implements AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(ProxySocket.class);
    private String destinationHost;
    private int destinationPort;
    private int sourcePort;
    private ExecutorService executorService;
    private ServerSocket sourceServerSocket;
    private AtomicBoolean isShutdown = new AtomicBoolean();

    public ProxySocket(String destinationHost, int destinationPort, int sourcePort, ExecutorService executorService) throws IOException {
        this.destinationHost = destinationHost;
        this.destinationPort = destinationPort;
        this.sourcePort = sourcePort;
        this.executorService = executorService;
        this.start();
    }

    private void start() throws IOException {
        this.sourceServerSocket = new ServerSocket(this.sourcePort);
        this.executorService.submit(() -> {
            byte[] request = new byte[1024];
            byte[] reply = new byte[4096];
            while (!this.isShutdown.get()) {
                try {
                    Socket sourceSocket = this.sourceServerSocket.accept();
                    try {
                        InputStream streamFromClient = sourceSocket.getInputStream();
                        try {
                            OutputStream streamToClient = sourceSocket.getOutputStream();
                            try (Socket destinationSocket = new Socket(this.destinationHost, this.destinationPort);){
                                this.executorService.submit(() -> {
                                    try (OutputStream streamToServer = destinationSocket.getOutputStream();){
                                        int bytesRead;
                                        while (!this.isShutdown.get() && (bytesRead = streamFromClient.read(request)) != -1) {
                                            streamToServer.write(request, 0, bytesRead);
                                            streamToServer.flush();
                                        }
                                    }
                                    catch (IOException e) {
                                        log.error("Failed to flush to dest", (Throwable)e);
                                    }
                                });
                                try {
                                    InputStream streamFromServer = destinationSocket.getInputStream();
                                    try {
                                        int bytesRead;
                                        while (!this.isShutdown.get() && (bytesRead = streamFromServer.read(reply)) != -1) {
                                            streamToClient.write(reply, 0, bytesRead);
                                            streamToClient.flush();
                                        }
                                    }
                                    finally {
                                        if (streamFromServer == null) continue;
                                        streamFromServer.close();
                                    }
                                }
                                catch (IOException e) {
                                    log.error("Failed to flush to client", (Throwable)e);
                                }
                            }
                            finally {
                                if (streamToClient == null) continue;
                                streamToClient.close();
                            }
                        }
                        finally {
                            if (streamFromClient == null) continue;
                            streamFromClient.close();
                        }
                    }
                    finally {
                        if (sourceSocket == null) continue;
                        sourceSocket.close();
                    }
                }
                catch (IOException e) {
                    log.error("Failed to open socket", (Throwable)e);
                }
            }
        });
    }

    public int getPort() {
        return this.sourceServerSocket.getLocalPort();
    }

    @Override
    public void close() {
        this.isShutdown.set(true);
        try {
            this.sourceServerSocket.close();
        }
        catch (IOException e) {
            log.error("Error while trying to close socket: " + e);
        }
        this.shutdownExecutorService();
    }

    private void shutdownExecutorService() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.error("Error occurred when await termination", (Throwable)e);
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

