/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.socket;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.fix.stdlib.socket.exeption.TooManyRetriesException;

public class SocketChecker {
    private static final Logger log = LoggerFactory.getLogger(SocketChecker.class);
    private static final int PORTS_FROM = 30000;
    private static final int PORTS_TO = 60000;

    private SocketChecker() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isAvailable(int port) {
        try (ServerSocket serverSocket = new ServerSocket(port);){
            DatagramSocket datagramSocket = new DatagramSocket(port);
            try {
                boolean bl = serverSocket.isBound() && datagramSocket.isBound();
                datagramSocket.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    datagramSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            log.trace("Failed to occupy socket during socket availability check.", (Throwable)exc);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int getAvailableRandomPort() {
        for (int attempt = 0; attempt < 100; ++attempt) {
            int port = ThreadLocalRandom.current().nextInt(30000, 60000);
            try (ServerSocket serverSocket = new ServerSocket();){
                DatagramSocket datagramSocket = new DatagramSocket(port);
                try {
                    serverSocket.setReuseAddress(true);
                    serverSocket.bind(new InetSocketAddress(port), 100);
                    int n = port;
                    datagramSocket.close();
                    return n;
                }
                catch (Throwable throwable) {
                    try {
                        datagramSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exc) {
                log.trace("Failed to occupy socket during socket availability check.", (Throwable)exc);
                continue;
            }
        }
        throw new TooManyRetriesException("100 attempts failed to get available random port.");
    }
}

