/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.dynamic.property.std.source;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.fix.dynamic.property.api.DynamicProperty;
import ru.fix.dynamic.property.api.PropertyListener;
import ru.fix.dynamic.property.api.PropertySubscription;
import ru.fix.dynamic.property.api.marshaller.DynamicPropertyMarshaller;
import ru.fix.dynamic.property.api.source.DynamicPropertySource;
import ru.fix.dynamic.property.api.source.OptionalDefaultValue;
import ru.fix.dynamic.property.std.source.InMemoryPropertySource;
import ru.fix.dynamic.property.std.source.PropertiesFileParser;
import ru.fix.stdlib.files.FileWatcher;
import ru.fix.stdlib.reference.ReferenceCleaner;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J8\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0004H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lru/fix/dynamic/property/std/source/FilePropertySource;", "Lru/fix/dynamic/property/api/source/DynamicPropertySource;", "sourceFilePath", "Lru/fix/dynamic/property/api/DynamicProperty;", "Ljava/nio/file/Path;", "propertyParser", "Lru/fix/dynamic/property/std/source/FilePropertySource$Parser;", "marshaller", "Lru/fix/dynamic/property/api/marshaller/DynamicPropertyMarshaller;", "referenceCleaner", "Lru/fix/stdlib/reference/ReferenceCleaner;", "(Lru/fix/dynamic/property/api/DynamicProperty;Lru/fix/dynamic/property/std/source/FilePropertySource$Parser;Lru/fix/dynamic/property/api/marshaller/DynamicPropertyMarshaller;Lru/fix/stdlib/reference/ReferenceCleaner;)V", "fileWatcher", "Lru/fix/stdlib/files/FileWatcher;", "inMemorySource", "Lru/fix/dynamic/property/std/source/InMemoryPropertySource;", "Lru/fix/dynamic/property/api/PropertySubscription;", "close", "", "createSubscription", "Lru/fix/dynamic/property/api/source/DynamicPropertySource$Subscription;", "T", "propertyName", "", "propertyType", "Ljava/lang/Class;", "defaultValue", "Lru/fix/dynamic/property/api/source/OptionalDefaultValue;", "updateProperties", "newPath", "Parser", "dynamic-property-std-source"})
public final class FilePropertySource
implements DynamicPropertySource {
    private final PropertySubscription<Path> sourceFilePath;
    private final InMemoryPropertySource inMemorySource;
    private final FileWatcher fileWatcher;
    private final Parser propertyParser;

    /*
     * WARNING - void declaration
     */
    private final void updateProperties(Path newPath) {
        void $this$filterTo$iv$iv;
        Map<String, String> newProperties = this.propertyParser.parsePropertiesFile(newPath);
        Object $this$forEach$iv = newProperties;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> $dstr$key$value = entry = iterator2.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry2 = $dstr$key$value;
            boolean bl3 = false;
            String key = entry2.getKey();
            entry2 = $dstr$key$value;
            bl3 = false;
            String value = entry2.getValue();
            this.inMemorySource.set(key, value);
        }
        Iterable $this$filter$iv = this.inMemorySource.propertyNames();
        boolean $i$f$filter = false;
        iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            Map<String, String> map = newProperties;
            boolean bl5 = false;
            Map<String, String> map2 = map;
            boolean bl6 = false;
            if (!(!map2.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            String name = (String)element$iv;
            boolean bl7 = false;
            this.inMemorySource.remove(name);
        }
    }

    @NotNull
    public <T> DynamicPropertySource.Subscription<T> createSubscription(@NotNull String propertyName, @NotNull Class<T> propertyType, @NotNull OptionalDefaultValue<T> defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        Intrinsics.checkParameterIsNotNull(propertyType, (String)"propertyType");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        return this.inMemorySource.createSubscription(propertyName, propertyType, defaultValue);
    }

    public void close() {
        this.sourceFilePath.close();
        this.fileWatcher.close();
        this.inMemorySource.close();
    }

    public FilePropertySource(@NotNull DynamicProperty<Path> sourceFilePath, @NotNull Parser propertyParser, @NotNull DynamicPropertyMarshaller marshaller, @NotNull ReferenceCleaner referenceCleaner) {
        Intrinsics.checkParameterIsNotNull(sourceFilePath, (String)"sourceFilePath");
        Intrinsics.checkParameterIsNotNull((Object)propertyParser, (String)"propertyParser");
        Intrinsics.checkParameterIsNotNull((Object)marshaller, (String)"marshaller");
        Intrinsics.checkParameterIsNotNull((Object)referenceCleaner, (String)"referenceCleaner");
        this.propertyParser = propertyParser;
        this.inMemorySource = new InMemoryPropertySource(marshaller, referenceCleaner);
        this.fileWatcher = new FileWatcher();
        PropertySubscription propertySubscription = sourceFilePath.createSubscription().setAndCallListener((PropertyListener)new PropertyListener<Path>(){

            public final void onPropertyChanged(Path prevPath, final Path newPath) {
                if (Intrinsics.areEqual((Object)newPath, (Object)prevPath) ^ true) {
                    if (prevPath != null) {
                        fileWatcher.unregister(prevPath);
                    }
                    FileWatcher fileWatcher = fileWatcher;
                    Path path = newPath;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"newPath");
                    fileWatcher.register(path, (Function1)new Function1<Path, Unit>(){

                        public final void invoke(@NotNull Path it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            FilePropertySource filePropertySource = this;
                            Path path = newPath;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"newPath");
                            filePropertySource.updateProperties(path);
                        }
                    });
                }
                Path path = newPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"newPath");
                this.updateProperties(path);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)propertySubscription, (String)"sourceFilePath.createSub\u2026ewPath)\n                }");
        this.sourceFilePath = propertySubscription;
    }

    public /* synthetic */ FilePropertySource(DynamicProperty dynamicProperty, Parser parser, DynamicPropertyMarshaller dynamicPropertyMarshaller, ReferenceCleaner referenceCleaner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            parser = PropertiesFileParser.INSTANCE;
        }
        if ((n & 8) != 0) {
            ReferenceCleaner referenceCleaner2 = ReferenceCleaner.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)referenceCleaner2, (String)"ReferenceCleaner.getInstance()");
            referenceCleaner = referenceCleaner2;
        }
        this((DynamicProperty<Path>)dynamicProperty, parser, dynamicPropertyMarshaller, referenceCleaner);
    }

    @FunctionalInterface
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lru/fix/dynamic/property/std/source/FilePropertySource$Parser;", "", "parsePropertiesFile", "", "", "filePath", "Ljava/nio/file/Path;", "dynamic-property-std-source"})
    public static interface Parser {
        @NotNull
        public Map<String, String> parsePropertiesFile(@NotNull Path var1);
    }
}

