/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.adocwrapper.block.image;

import java.io.InputStream;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.curs.adocwrapper.block.StructuralNode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004J\b\u0010\r\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lru/curs/adocwrapper/block/image/Image;", "Lru/curs/adocwrapper/block/StructuralNode;", "()V", "image", "", "base64", "", "inputStream", "Ljava/io/InputStream;", "format", "Lru/curs/adocwrapper/block/image/Image$ImageFormat;", "encodedString", "path", "toString", "ImageFormat", "asciidoc-kotlin-wrapper"})
public final class Image
extends StructuralNode {
    @NotNull
    private String image = "";

    @NotNull
    public String toString() {
        return this.image;
    }

    public final void path(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.image = "\nimage::" + path + "[]\n";
    }

    public final void base64(@NotNull String encodedString, @NotNull ImageFormat format) {
        Intrinsics.checkNotNullParameter((Object)encodedString, (String)"encodedString");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        this.image = "\nimage::data:image/" + format.getExtension() + ";base64," + encodedString + "[]\n";
    }

    public final void base64(@NotNull InputStream inputStream, @NotNull ImageFormat format) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        byte[] sourceBytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        String encodedString = Base64.getEncoder().encodeToString(sourceBytes);
        this.image = "\nimage::data:image/" + format.getExtension() + ";base64," + encodedString + "[]\n";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lru/curs/adocwrapper/block/image/Image$ImageFormat;", "", "extension", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "PNG", "JPEG", "asciidoc-kotlin-wrapper"})
    public static final class ImageFormat
    extends Enum<ImageFormat> {
        @NotNull
        private final String extension;
        public static final /* enum */ ImageFormat PNG = new ImageFormat("png");
        public static final /* enum */ ImageFormat JPEG = new ImageFormat("jpeg");
        private static final /* synthetic */ ImageFormat[] $VALUES;

        private ImageFormat(String extension) {
            this.extension = extension;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        public static ImageFormat[] values() {
            return (ImageFormat[])$VALUES.clone();
        }

        public static ImageFormat valueOf(String value) {
            return Enum.valueOf(ImageFormat.class, value);
        }

        static {
            $VALUES = imageFormatArray = new ImageFormat[]{ImageFormat.PNG, ImageFormat.JPEG};
        }
    }
}

