package ru.curs.adocwrapper.utils

import ru.curs.adocwrapper.inline.Inline

class TitleString(string: String) : Inline(string) {
    override fun toString(): String {
        return text
    }

    override fun checkValid() {
        val pattern = "[^\n]+"
        if (! (Regex(pattern) matches text)) {
            throw Exception("String [$text] should match [$pattern]")
        }
    }
}
