package ru.curs.adocwrapper.utils

import ru.curs.adocwrapper.inline.Inline

class RoleString(string: String) : Inline(string) {
    override fun checkValid() {
        val pattern = "[a-zA-Z_][a-zA-Z0-9_-]*"
        if (! (Regex(pattern) matches text)) {
            throw Exception("String [$text] should match [$pattern]")
        }
    }
}
