package ru.curs.adocwrapper.inline.text

class Link(text: String, val url: String) : AdocText(text) {
    override fun toString(): String {
        return "$url[$text]"
    }

    override fun toHabrMd(): String {
        return "[$text]($url)"
    }

    override fun toText(): String {
        return text
    }

    init {
        super.checkValid()
        val urlPattern = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"
        if (! (Regex(urlPattern) matches url)) {
            throw Exception("URL [$url] should match [$urlPattern]")
        }
    }
}
