package ru.curs.adocwrapper.inline.text

import ru.curs.adocwrapper.AsciidocValidatorFactory
import ru.curs.adocwrapper.DBFactory
import ru.curs.adocwrapper.XPFactory
import ru.curs.adocwrapper.inline.InlineContentType
import ru.curs.adocwrapper.inline.UnsafeInline

open class AdocText(text: String) : UnsafeInline(text) {
    init {
        this.type = InlineContentType.NormalText
    }

    override fun checkValid() {
    }

    private fun checkHasNoAsciidocMarkup() {
        val xmlRepresentation = DBFactory.parseDocument(AsciidocValidatorFactory.getXML(text))
        if (XPFactory.eval("//*[@block = 'true']", xmlRepresentation).length != 2) {
            throw Exception("String has asciidoc block elements: \n--------\n$text\n--------\n")
        }
        if (XPFactory.eval("/embedded/paragraph/*", xmlRepresentation).length != 0) {
            throw Exception("String has asciidoc inline elements: \n--------\n$text\n--------\n")
        }
    }
}
