package ru.curs.adocwrapper.block.table

import ru.curs.adocwrapper.block.*
import ru.curs.adocwrapper.block.paragraph.Paragraph

class TableData : StructuralNode() {
    private var align = ""
    private var colSpan = ""
    private var rowSpan = ""
    private var result = ""
    private var asciidocType = ""
    private var roles = ""
    override fun toString(): String {
        result += "|"
        blocks.forEachIndexed { index, adocDSLStructuralNode ->
            result += if ((index == 0) and (adocDSLStructuralNode.type == NodeType.Para)) {
                val para = adocDSLStructuralNode as Paragraph
                "$para"
            } else {
                "\n\n$adocDSLStructuralNode"
            }
        }
        return "$colSpan$rowSpan$align$asciidocType$roles$result"
    }

    public override fun p(init: Paragraph.() -> Unit): Paragraph {
        val newPara = super.p(init)
        newPara.paraType = if (blocks.size == 1) ParaType.FirstList else ParaType.OtherList
        return newPara
    }

    fun role(vararg role: String) {
        role.forEach { roles += ".$it" }
        roles = "[$roles]"
    }

    fun align (ha : HA? = null, va: VA? = null) {
        if (ha != null) {
            align += ha.align
        }
        if (va != null) {
            align += va.align
        }
    }

    fun colSpan(span : Int) {
        colSpan += "${span}."
    }

    fun rowSpan(span : Int) {
        rowSpan += "${span}+"
    }

    fun type(asciidoc: TDT) {
        asciidocType += asciidoc.type
    }
}
