package ru.curs.adocwrapper.block.section

import ru.curs.adocwrapper.block.StructuralNode


class Section : StructuralNode() {
    override fun toString(): String {
        var returnString =
            "\n\n${getIdRoleSyntax()}${getAttributesSyntax()}${"=".repeat(sectionLevel !!.plus(1))} $title"
        blocks.forEach { returnString += it.toString() }
        return returnString
    }

    override fun toHabrMd(): String {
        var returnString =
            "\n\n${"#".repeat(sectionLevel !!.plus(1))} $title"
        blocks.forEach { returnString += it.toString() }
        return returnString
    }

    override fun toText(): String {
        var returnString =
            "\n\n$title"
        blocks.forEach { returnString += it.toText() }
        return returnString
    }

    public override fun section(init: Section.() -> Unit): Section {
        return super.section(init)
    }
}
