package ru.curs.adocwrapper.block.list

import ru.curs.adocwrapper.block.LIType
import ru.curs.adocwrapper.block.NodeType
import ru.curs.adocwrapper.block.ParaType
import ru.curs.adocwrapper.block.StructuralNode
import ru.curs.adocwrapper.block.paragraph.Paragraph

class ListItem(private val liType: LIType) : StructuralNode() {
    override fun toString(): String {
        var returnString = ""
        blocks.forEachIndexed { index, adocDSLStructuralNode ->
            returnString += if ((index == 0) and (adocDSLStructuralNode.type == NodeType.Para)) {
                val para = adocDSLStructuralNode as Paragraph
                "\n${if (liType == LIType.U) "*" else "."} $para"
            } else {
                "\n+\n$adocDSLStructuralNode"
            }
        }
        return returnString
    }

    override fun toHabrMd(): String {
        var returnString = ""
        blocks.forEachIndexed { index, adocDSLStructuralNode ->
            returnString += if ((index == 0) and (adocDSLStructuralNode.type == NodeType.Para)) {
                val para = adocDSLStructuralNode as Paragraph
                "\n${if (liType == LIType.U) "*" else "1."} ${para.toHabrMd()}"
            } else if ((index == 1) and (adocDSLStructuralNode.type == NodeType.Para)) {
                "\n\n  ${adocDSLStructuralNode.toHabrMd()}\n"
            } else {
                "\n  ${adocDSLStructuralNode.toHabrMd()}\n"
            }
        }
        return returnString
    }

    override fun toText(): String {
        var returnString = ""
        blocks.forEachIndexed { index, adocDSLStructuralNode ->
            returnString += if ((index == 0) and (adocDSLStructuralNode.type == NodeType.Para)) {
                val para = adocDSLStructuralNode as Paragraph
                "\n\n- ${para.toText()}"
            } else if ((index == 1) and (adocDSLStructuralNode.type == NodeType.Para)) {
                "\n\n${adocDSLStructuralNode.toText()}\n"
            } else {
                "\n${adocDSLStructuralNode.toText()}\n"
            }
        }
        return returnString
    }

    public override fun p(init: Paragraph.() -> Unit): Paragraph {
        val newPara = super.p(init)
        newPara.paraType = if (blocks.size == 1) ParaType.FirstList else ParaType.OtherList
        return newPara
    }

}
