package ru.curs.adocwrapper.block

import ru.curs.adocwrapper.block.image.Image
import ru.curs.adocwrapper.block.list.OList
import ru.curs.adocwrapper.block.list.UList
import ru.curs.adocwrapper.block.paragraph.Paragraph
import ru.curs.adocwrapper.block.section.Section
import ru.curs.adocwrapper.block.signature.Signature
import ru.curs.adocwrapper.block.table.Table
import ru.curs.adocwrapper.block.video.Video
import ru.curs.adocwrapper.inline.Inline
import ru.curs.adocwrapper.inline.InlineContent
import ru.curs.adocwrapper.inline.text.Link
import ru.curs.adocwrapper.utils.AttrNameString
import ru.curs.adocwrapper.utils.IdString
import ru.curs.adocwrapper.utils.RoleString
import ru.curs.adocwrapper.utils.TitleString
import java.util.*

@DslMarker
annotation class AsciidocTagMarker

@AsciidocTagMarker
open class StructuralNode {
    var sectionLevel: Int? = null
    open val type = NodeType.Any
    val blocks = arrayListOf<StructuralNode>()
    private val roles: SortedSet<RoleString> = sortedSetOf()
    private var id: IdString? = null
    var title: TitleString? = null
    val attrs: SortedMap<AttrNameString, String> = sortedMapOf()

    fun attr(name: String, value: String) {
        attrs[AttrNameString(name)] = value
    }


    open fun toHabrMd(): String {
        return this.toString()
    }

    open fun toText(): String {
        return this.toString()
    }

    protected var inlineContent: InlineContent = InlineContent()

    protected open fun text(string: String) {
        inlineContent.add(Inline(string))
    }

    fun link(text: String, url: String): Link {
        return Link(text, url)
    }

    fun video(text: String): Video {
        return Video(text)
    }

    fun id(id: String) {
        this.id = IdString(id)
    }

    fun title(title: String) {
        this.title = TitleString(title)
    }

    fun roles(vararg roles: String) {
        roles.forEach { role ->
            this.roles.add(RoleString(role))
        }
    }

    protected open fun ol(init: OList.() -> Unit): OList {
        val list = OList()
        list.apply(init)
        this.blocks.add(list)
        return list
    }

    protected open fun ul(init: UList.() -> Unit): UList {
        val list = UList()
        list.apply(init)
        this.blocks.add(list)
        return list
    }

    protected open fun section(init: Section.() -> Unit): Section {
        val section = Section()
        section.apply(init)
        section.sectionLevel = this.sectionLevel !! + 1
        this.blocks.add(section)
        return section
    }

    protected open fun table(init: Table.() -> Unit): Table {
        val table = Table()
        table.apply(init)
        this.blocks.add(table)
        return table
    }

    protected open fun image(init: Image.() -> Unit): Image {
        val image = Image()
        image.apply(init)
        this.blocks.add(image)
        return image
    }

    protected open fun signature(init: Signature.() -> Unit): Signature {
        val signature = Signature()
        signature.apply(init)
        this.blocks.add(signature)
        return signature
    }

    protected open fun p(init: Paragraph.() -> Unit): Paragraph {

        val para = Paragraph()
        para.apply(init)
        this.blocks.add(para)
        return para
    }

    fun getIdRoleSyntax(): String {
        if (id == null && roles.isEmpty()) return ""
        val strings = mutableListOf<String>()
        if (id != null) {
            strings += mutableListOf("#$id")
        }
        strings += roles.map { role -> ".$role" }.toMutableList()
        return strings.joinToString("", "[", "]\n")
    }

    private fun getLocalTitleSyntax(): String {
        if (title != null) {
            return ".$title\n"
        }
        return ""
    }

    fun getAttributesSyntax(): String {
        if (attrs.isNotEmpty()) {
            return attrs.map { "${it.key}=\"${it.value}\"" }.joinToString(", ", "[", "]\n")
        }
        return ""
    }

    fun getBlockMetaSyntax(): String {
        return getIdRoleSyntax() + getLocalTitleSyntax() + getAttributesSyntax()
    }

}