/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bozaro.gitlfs.common.JsonHelper;
import ru.bozaro.gitlfs.common.data.BatchItem;
import ru.bozaro.gitlfs.common.data.BatchReq;
import ru.bozaro.gitlfs.common.data.BatchRes;
import ru.bozaro.gitlfs.common.data.Error;
import ru.bozaro.gitlfs.common.data.Link;
import ru.bozaro.gitlfs.common.data.LinkType;
import ru.bozaro.gitlfs.common.data.Meta;
import ru.bozaro.gitlfs.common.data.ObjectRes;
import ru.bozaro.gitlfs.common.data.Operation;
import ru.bozaro.gitlfs.server.ContentManager;
import ru.bozaro.gitlfs.server.ForbiddenError;
import ru.bozaro.gitlfs.server.LocalPointerManager;
import ru.bozaro.gitlfs.server.PointerManager;
import ru.bozaro.gitlfs.server.ServerError;
import ru.bozaro.gitlfs.server.UnauthorizedError;
import ru.bozaro.gitlfs.server.internal.ObjectResponse;
import ru.bozaro.gitlfs.server.internal.ResponseWriter;

public class PointerServlet
extends HttpServlet {
    @NotNull
    private static final Pattern PATTERN_OID = Pattern.compile("^/[0-9a-f]{64}$");
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final PointerManager manager;
    @NotNull
    private final AccessCheckerVisitor accessCheckerVisitor;

    public PointerServlet(@NotNull ContentManager manager, @NotNull String contentLocation) {
        this(new LocalPointerManager(manager, contentLocation));
    }

    public PointerServlet(@NotNull PointerManager manager) {
        this.manager = manager;
        this.mapper = JsonHelper.mapper;
        this.accessCheckerVisitor = new AccessCheckerVisitor(manager);
    }

    @NotNull
    private static BatchItem[] filterLocations(@NotNull BatchItem[] items, @NotNull LocationFilter filter) throws IOException {
        BatchItem[] result = new BatchItem[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = items[i].getError() == null ? filter.filter(items[i]) : items[i];
        }
        return result;
    }

    @NotNull
    private static BatchItem filterDownload(@NotNull BatchItem item) {
        if (item.getLinks().containsKey(LinkType.Download)) {
            return new BatchItem(item.getOid(), item.getSize(), PointerServlet.filterLocation(item.getLinks(), LinkType.Download), null, null);
        }
        return new BatchItem(item.getOid(), item.getSize(), null, null, new Error(404, "Object not found"));
    }

    private static Map<LinkType, Link> filterLocation(@NotNull Map<LinkType, Link> links, LinkType ... linkTypes) {
        TreeMap<LinkType, Link> result = new TreeMap<LinkType, Link>();
        for (LinkType linkType : linkTypes) {
            Link link = links.get(linkType);
            if (link == null) continue;
            result.put(linkType, link);
        }
        return result;
    }

    @NotNull
    private static BatchItem filterUpload(@NotNull BatchItem item) throws IOException {
        if (item.getLinks().containsKey(LinkType.Download)) {
            return new BatchItem(item.getOid(), item.getSize(), PointerServlet.filterLocation(item.getLinks(), LinkType.Download), null, null);
        }
        if (item.getLinks().containsKey(LinkType.Upload)) {
            return new BatchItem(item.getOid(), item.getSize(), PointerServlet.filterLocation(item.getLinks(), LinkType.Upload, LinkType.Verify), null, null);
        }
        throw new IOException("Upload link not found");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (req.getPathInfo() != null && PATTERN_OID.matcher(req.getPathInfo()).matches()) {
                this.processObjectGet(req, req.getPathInfo().substring(1)).write(resp);
                return;
            }
        }
        catch (ServerError e) {
            PointerServlet.sendError(resp, e);
            return;
        }
        super.doGet(req, resp);
    }

    protected void doPost(@NotNull HttpServletRequest req, @NotNull HttpServletResponse resp) throws ServletException, IOException {
        try {
            PointerServlet.checkMimeTypes(req);
            if (req.getPathInfo() == null) {
                this.processObjectPost(req).write(resp);
                return;
            }
            if ("/batch".equals(req.getPathInfo())) {
                this.processBatchPost(req).write(resp);
                return;
            }
        }
        catch (ServerError e) {
            PointerServlet.sendError(resp, e);
            return;
        }
        super.doPost(req, resp);
    }

    public static void checkMimeTypes(@NotNull HttpServletRequest request) throws ServerError {
        PointerServlet.checkMimeType(request.getContentType());
        PointerServlet.checkMimeType(request.getHeader("Accept"));
    }

    @NotNull
    private ResponseWriter processObjectPost(@NotNull HttpServletRequest req) throws ServerError, IOException {
        Meta meta;
        URI selfUrl = this.getSelfUrl(req);
        PointerManager.Locator locator = this.manager.checkUploadAccess(req, selfUrl);
        BatchItem location = this.getLocation(locator, meta = (Meta)this.mapper.readValue((InputStream)req.getInputStream(), Meta.class));
        Error error = location.getError();
        if (error != null) {
            throw new ServerError(error.getCode(), error.getMessage(), null);
        }
        TreeMap<LinkType, Link> links = new TreeMap<LinkType, Link>(location.getLinks());
        links.put(LinkType.Self, new Link(selfUrl, null, null));
        if (links.containsKey(LinkType.Download)) {
            return new ObjectResponse(200, new ObjectRes(location.getOid(), location.getSize(), PointerServlet.addSelfLink(req, links)));
        }
        if (links.containsKey(LinkType.Upload)) {
            return new ObjectResponse(202, new ObjectRes(location.getOid(), location.getSize(), PointerServlet.addSelfLink(req, links)));
        }
        throw new ServerError(500, "Invalid locations list", null);
    }

    @NotNull
    private ResponseWriter processBatchPost(@NotNull HttpServletRequest req) throws ServerError, IOException {
        BatchReq batchReq = (BatchReq)this.mapper.readValue((InputStream)req.getInputStream(), BatchReq.class);
        PointerManager.Locator locator = ((AccessChecker)batchReq.getOperation().visit((Operation.Visitor)this.accessCheckerVisitor)).checkAccess(req, this.getSelfUrl(req));
        BatchItem[] locations = this.getLocations(locator, batchReq.getObjects().toArray(new Meta[batchReq.getObjects().size()]));
        return new ObjectResponse(200, new BatchRes(Arrays.asList(locations)));
    }

    private static void checkMimeType(@Nullable String contentType) throws ServerError {
        int separator;
        String actualType = contentType;
        if (actualType != null && (separator = actualType.indexOf(59)) >= 0) {
            while (separator > 1 && actualType.charAt(separator - 1) == ' ') {
                --separator;
            }
            actualType = actualType.substring(0, separator);
        }
        if (!"application/vnd.git-lfs+json".equals(actualType)) {
            throw new ServerError(406, "Not Acceptable", null);
        }
    }

    @NotNull
    private ResponseWriter processObjectGet(@NotNull HttpServletRequest req, @NotNull String oid) throws ServerError, IOException {
        PointerManager.Locator locator = this.manager.checkDownloadAccess(req, this.getSelfUrl(req));
        BatchItem location = this.getLocation(locator, new Meta(oid, -1L));
        Error error = location.getError();
        if (error != null) {
            throw new ServerError(error.getCode(), error.getMessage(), null);
        }
        if (location.getLinks().containsKey(LinkType.Download)) {
            return new ObjectResponse(200, new ObjectRes(location.getOid(), location.getSize(), PointerServlet.addSelfLink(req, location.getLinks())));
        }
        throw new ServerError(404, "Object not found", null);
    }

    public static void sendError(@NotNull HttpServletResponse resp, @NotNull ServerError e) throws IOException {
        resp.setStatus(e.getStatusCode());
        resp.setContentType("application/vnd.git-lfs+json");
        JsonHelper.mapper.writeValue((OutputStream)resp.getOutputStream(), (Object)new Error(e.getStatusCode(), e.getMessage()));
    }

    @NotNull
    protected URI getSelfUrl(@NotNull HttpServletRequest req) {
        try {
            return new URI(req.getScheme(), null, req.getServerName(), req.getServerPort(), req.getServletPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can't create request URL", e);
        }
    }

    @NotNull
    private BatchItem getLocation(@NotNull PointerManager.Locator locator, @NotNull Meta meta) throws IOException, ServerError {
        return this.getLocations(locator, new Meta[]{meta})[0];
    }

    private static Map<LinkType, Link> addSelfLink(@NotNull HttpServletRequest req, @NotNull Map<LinkType, Link> links) {
        TreeMap<LinkType, Link> result = new TreeMap<LinkType, Link>(links);
        result.put(LinkType.Self, new Link(URI.create(String.valueOf(req.getRequestURL())), null, null));
        return result;
    }

    @NotNull
    private BatchItem[] getLocations(@NotNull PointerManager.Locator locator, @NotNull Meta[] metas) throws ServerError, IOException {
        BatchItem[] locations = locator.getLocations(metas);
        if (locations.length != metas.length) {
            throw new ServerError(500, "Unexpected locations array size", null);
        }
        for (int i = 0; i < locations.length; ++i) {
            if (Objects.equals(metas[i].getOid(), locations[i].getOid())) continue;
            throw new ServerError(500, "Metadata mismatch", null);
        }
        return locations;
    }

    private static class AccessCheckerVisitor
    implements Operation.Visitor<AccessChecker> {
        @NotNull
        private final PointerManager manager;

        public AccessCheckerVisitor(@NotNull PointerManager manager) {
            this.manager = manager;
        }

        public AccessChecker visitDownload() {
            return this.wrapChecker(this.manager::checkDownloadAccess, x$0 -> PointerServlet.filterDownload(x$0));
        }

        public AccessChecker visitUpload() {
            return this.wrapChecker(this.manager::checkUploadAccess, x$0 -> PointerServlet.filterUpload(x$0));
        }

        private AccessChecker wrapChecker(@NotNull AccessChecker checker, @NotNull LocationFilter filter) {
            return (request, selfUrl) -> {
                PointerManager.Locator locator = checker.checkAccess(request, selfUrl);
                return metas -> PointerServlet.filterLocations(locator.getLocations(metas), filter);
            };
        }
    }

    @FunctionalInterface
    protected static interface LocationFilter {
        @NotNull
        public BatchItem filter(@NotNull BatchItem var1) throws IOException;
    }

    @FunctionalInterface
    protected static interface AccessChecker {
        @NotNull
        public PointerManager.Locator checkAccess(@NotNull HttpServletRequest var1, @NotNull URI var2) throws IOException, ForbiddenError, UnauthorizedError;
    }
}

