/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import ru.bozaro.gitlfs.common.JsonHelper;
import ru.bozaro.gitlfs.common.LockConflictException;
import ru.bozaro.gitlfs.common.VerifyLocksResult;
import ru.bozaro.gitlfs.common.data.CreateLockReq;
import ru.bozaro.gitlfs.common.data.CreateLockRes;
import ru.bozaro.gitlfs.common.data.DeleteLockReq;
import ru.bozaro.gitlfs.common.data.Lock;
import ru.bozaro.gitlfs.common.data.LocksRes;
import ru.bozaro.gitlfs.common.data.Ref;
import ru.bozaro.gitlfs.common.data.VerifyLocksReq;
import ru.bozaro.gitlfs.common.data.VerifyLocksRes;
import ru.bozaro.gitlfs.server.LockManager;
import ru.bozaro.gitlfs.server.PointerServlet;
import ru.bozaro.gitlfs.server.ServerError;
import ru.bozaro.gitlfs.server.internal.ObjectResponse;
import ru.bozaro.gitlfs.server.internal.ResponseWriter;

public class LocksServlet
extends HttpServlet {
    @NotNull
    private final LockManager lockManager;

    public LocksServlet(@NotNull LockManager lockManager) {
        this.lockManager = lockManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            LockManager.LockRead lockRead = this.lockManager.checkDownloadAccess(req);
            if (req.getPathInfo() == null) {
                this.listLocks(req, lockRead).write(resp);
                return;
            }
        }
        catch (ServerError e) {
            PointerServlet.sendError(resp, e);
            return;
        }
        super.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            PointerServlet.checkMimeTypes(req);
            LockManager.LockWrite lockWrite = this.lockManager.checkUploadAccess(req);
            if (req.getPathInfo() == null) {
                this.createLock(req, lockWrite).write(resp);
                return;
            }
            if ("/verify".equals(req.getPathInfo())) {
                this.verifyLocks(req, lockWrite).write(resp);
                return;
            }
            if (req.getPathInfo().endsWith("/unlock")) {
                this.deleteLock(req, lockWrite, req.getPathInfo().substring(1, req.getPathInfo().length() - 7)).write(resp);
                return;
            }
        }
        catch (ServerError e) {
            PointerServlet.sendError(resp, e);
            return;
        }
        super.doPost(req, resp);
    }

    @NotNull
    private ResponseWriter createLock(@NotNull HttpServletRequest req, @NotNull LockManager.LockWrite lockWrite) throws IOException {
        CreateLockReq createLockReq = (CreateLockReq)JsonHelper.mapper.readValue((InputStream)req.getInputStream(), CreateLockReq.class);
        try {
            Lock lock = lockWrite.lock(createLockReq.getPath(), createLockReq.getRef());
            return new ObjectResponse(201, new CreateLockRes(lock));
        }
        catch (LockConflictException e) {
            return new ObjectResponse(409, new CreateLockRes(e.getLock()));
        }
    }

    @NotNull
    private ResponseWriter verifyLocks(@NotNull HttpServletRequest req, @NotNull LockManager.LockWrite lockWrite) throws IOException {
        VerifyLocksReq verifyLocksReq = (VerifyLocksReq)JsonHelper.mapper.readValue((InputStream)req.getInputStream(), VerifyLocksReq.class);
        VerifyLocksResult result = lockWrite.verifyLocks(verifyLocksReq.getRef());
        return new ObjectResponse(200, new VerifyLocksRes(result.getOurLocks(), result.getTheirLocks(), null));
    }

    @NotNull
    private ResponseWriter deleteLock(@NotNull HttpServletRequest req, @NotNull LockManager.LockWrite lockWrite, @NotNull String lockId) throws IOException, ServerError {
        DeleteLockReq deleteLockReq = (DeleteLockReq)JsonHelper.mapper.readValue((InputStream)req.getInputStream(), DeleteLockReq.class);
        try {
            Lock lock = lockWrite.unlock(lockId, deleteLockReq.isForce(), deleteLockReq.getRef());
            if (lock == null) {
                throw new ServerError(404, String.format("Lock %s not found", lockId));
            }
            return new ObjectResponse(200, new CreateLockRes(lock));
        }
        catch (LockConflictException e) {
            return new ObjectResponse(403, new CreateLockRes(e.getLock()));
        }
    }

    @NotNull
    private ResponseWriter listLocks(@NotNull HttpServletRequest req, @NotNull LockManager.LockRead lockRead) throws IOException {
        String refName = req.getParameter("refspec");
        String path = req.getParameter("path");
        String lockId = req.getParameter("id");
        List<Lock> locks = lockRead.getLocks(path, lockId, Ref.create((String)refName));
        return new ObjectResponse(200, new LocksRes(locks, null));
    }
}

