/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.server;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bozaro.gitlfs.common.data.BatchItem;
import ru.bozaro.gitlfs.common.data.Error;
import ru.bozaro.gitlfs.common.data.Link;
import ru.bozaro.gitlfs.common.data.LinkType;
import ru.bozaro.gitlfs.common.data.Meta;
import ru.bozaro.gitlfs.server.ContentManager;
import ru.bozaro.gitlfs.server.ForbiddenError;
import ru.bozaro.gitlfs.server.PointerManager;
import ru.bozaro.gitlfs.server.UnauthorizedError;

public class LocalPointerManager
implements PointerManager {
    @NotNull
    private final ContentManager manager;
    @NotNull
    private final String contentLocation;

    public LocalPointerManager(@NotNull ContentManager manager, @NotNull String contentLocation) {
        this.manager = manager;
        this.contentLocation = contentLocation.endsWith("/") ? contentLocation : contentLocation + "/";
    }

    @Override
    @NotNull
    public PointerManager.Locator checkUploadAccess(@NotNull HttpServletRequest request, @NotNull URI selfUrl) throws IOException, ForbiddenError, UnauthorizedError {
        ContentManager.Uploader headerProvider = this.manager.checkUploadAccess(request);
        return this.createLocator(request, headerProvider, selfUrl);
    }

    @Override
    @NotNull
    public PointerManager.Locator checkDownloadAccess(@NotNull HttpServletRequest request, @NotNull URI selfUrl) throws IOException, ForbiddenError, UnauthorizedError {
        ContentManager.Downloader headerProvider = this.manager.checkDownloadAccess(request);
        return this.createLocator(request, headerProvider, selfUrl);
    }

    protected Map<String, String> createDefaultHeader(@NotNull HttpServletRequest request) {
        String auth = request.getHeader("Authorization");
        HashMap<String, String> header = new HashMap<String, String>();
        if (auth != null) {
            header.put("Authorization", auth);
        }
        return header;
    }

    protected PointerManager.Locator createLocator(@NotNull HttpServletRequest request, @NotNull ContentManager.HeaderProvider headerProvider, final @NotNull URI selfUrl) {
        final Map<String, String> header = headerProvider.createHeader(this.createDefaultHeader(request));
        return new PointerManager.Locator(){

            @Override
            @NotNull
            public BatchItem[] getLocations(@NotNull Meta[] metas) throws IOException {
                BatchItem[] result = new BatchItem[metas.length];
                for (int i = 0; i < metas.length; ++i) {
                    result[i] = this.getLocation(header, selfUrl, metas[i]);
                }
                return result;
            }

            @NotNull
            public BatchItem getLocation(@Nullable Map<String, String> header2, @NotNull URI selfUrl2, @NotNull Meta meta) throws IOException {
                Meta storageMeta = LocalPointerManager.this.manager.getMetadata(meta.getOid());
                if (storageMeta == null) {
                    return new BatchItem(meta, Collections.singletonMap(LinkType.Upload, new Link(selfUrl2.resolve(LocalPointerManager.this.contentLocation).resolve(meta.getOid()), header2, null)));
                }
                if (meta.getSize() >= 0L && storageMeta.getSize() != meta.getSize()) {
                    return new BatchItem(meta, new Error(422, "Invalid object size"));
                }
                return new BatchItem(storageMeta, Collections.singletonMap(LinkType.Download, new Link(selfUrl2.resolve(LocalPointerManager.this.contentLocation).resolve(storageMeta.getOid()), header2, null)));
            }
        };
    }
}

