/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import ru.bozaro.gitlfs.common.data.Meta;
import ru.bozaro.gitlfs.common.io.InputStreamValidator;
import ru.bozaro.gitlfs.server.ContentManager;
import ru.bozaro.gitlfs.server.PointerServlet;
import ru.bozaro.gitlfs.server.ServerError;
import ru.bozaro.gitlfs.server.internal.ObjectResponse;
import ru.bozaro.gitlfs.server.internal.ResponseWriter;

public class ContentServlet
extends HttpServlet {
    @NotNull
    private final Pattern PATTERN_OID = Pattern.compile("^/[0-9a-f]{64}$");
    @NotNull
    private final ContentManager manager;

    public ContentServlet(@NotNull ContentManager manager) {
        this.manager = manager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (req.getPathInfo() != null && this.PATTERN_OID.matcher(req.getPathInfo()).matches()) {
                this.processGet(req, req.getPathInfo().substring(1)).write(resp);
                return;
            }
        }
        catch (ServerError e) {
            PointerServlet.sendError(resp, e);
            return;
        }
        super.doGet(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (req.getPathInfo() != null && this.PATTERN_OID.matcher(req.getPathInfo()).matches()) {
                this.processPut(req, req.getPathInfo().substring(1)).write(resp);
                return;
            }
        }
        catch (ServerError e) {
            PointerServlet.sendError(resp, e);
            return;
        }
        super.doPut(req, resp);
    }

    @NotNull
    private ResponseWriter processPut(@NotNull HttpServletRequest req, @NotNull String oid) throws ServerError, IOException {
        ContentManager.Uploader uploader = this.manager.checkUploadAccess(req);
        Meta meta = new Meta(oid, -1L);
        uploader.saveObject(meta, (InputStream)new InputStreamValidator((InputStream)req.getInputStream(), meta));
        return new ObjectResponse(200, meta);
    }

    @NotNull
    private ResponseWriter processGet(@NotNull HttpServletRequest req, @NotNull String oid) throws ServerError, IOException {
        ContentManager.Downloader downloader = this.manager.checkDownloadAccess(req);
        final InputStream stream = downloader.openObject(oid);
        return new ResponseWriter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(@NotNull HttpServletResponse response) throws IOException {
                response.setStatus(200);
                response.setContentType("application/octet-stream");
                try {
                    int read;
                    byte[] buffer = new byte[65536];
                    while ((read = stream.read(buffer)) >= 0) {
                        response.getOutputStream().write(buffer, 0, read);
                    }
                }
                finally {
                    stream.close();
                }
            }
        };
    }
}

