/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.routing.dmn;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.OutputEntry;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.FileLoaderUtil;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.spi.routing.api.TaskRoutingProvider;
import pro.taskana.task.api.models.Task;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

public class DmnTaskRouter
implements TaskRoutingProvider {
    private static final Logger LOGGER;
    private static final String DMN_TABLE_PROPERTY = "taskana.routing.dmn";
    private static final String DECISION_ID = "workbasketRouting";
    private static final String DECISION_VARIABLE_MAP_NAME = "task";
    private static final String OUTPUT_WORKBASKET_KEY = "workbasketKey";
    private static final String OUTPUT_DOMAIN = "domain";
    private TaskanaEngine taskanaEngine;
    private DmnEngine dmnEngine;
    private DmnDecision decision;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        DmnTaskRouter.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DmnTaskRouter.class);
    }

    public void initialize(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine = taskanaEngine;
        this.dmnEngine = DmnEngineConfiguration.createDefaultDmnEngineConfiguration().buildEngine();
        DmnModelInstance dmnModel = this.readModelFromDmnTable();
        this.decision = this.dmnEngine.parseDecision(DECISION_ID, dmnModel);
        this.validateOutputs(dmnModel);
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String determineWorkbasketId(Task task) {
        String string;
        String string2;
        String string3;
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)task2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        VariableMap variables = Variables.putValue((String)DECISION_VARIABLE_MAP_NAME, (Object)task);
        DmnDecisionTableResult result = this.dmnEngine.evaluateDecisionTable(this.decision, (Map)variables);
        if (result.getSingleResult() == null) {
            string2 = string3 = null;
        } else {
            String string4;
            String workbasketKey = (String)result.getSingleResult().getEntry(OUTPUT_WORKBASKET_KEY);
            String domain = (String)result.getSingleResult().getEntry(OUTPUT_DOMAIN);
            try {
                string4 = this.taskanaEngine.getWorkbasketService().getWorkbasket(workbasketKey, domain).getId();
            }
            catch (WorkbasketNotFoundException workbasketNotFoundException) {
                throw new SystemException(String.format("Unknown workbasket defined in DMN Table. key: '%s', domain: '%s'", workbasketKey, domain));
            }
            catch (NotAuthorizedOnWorkbasketException notAuthorizedOnWorkbasketException) {
                throw new SystemException(String.format("The current user is not authorized to create a task in the routed workbasket. key: '%s', domain: '%s'", workbasketKey, domain));
            }
            string2 = string3 = string4;
        }
        String string5 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, string);
        return string3;
    }

    protected Set<Pair<String, String>> getAllWorkbasketAndDomainOutputs(DmnModelInstance dmnModel) {
        HashSet<Pair<String, String>> hashSet;
        HashSet<Pair<String, String>> hashSet2;
        DmnModelInstance dmnModelInstance = dmnModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)dmnModelInstance);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashSet<Pair<String, String>> allWorkbasketAndDomainOutputs = new HashSet<Pair<String, String>>();
        for (Rule rule : dmnModel.getModelElementsByType(Rule.class)) {
            ArrayList outputEntries = new ArrayList(rule.getOutputEntries());
            String workbasketKey = ((OutputEntry)outputEntries.get(0)).getTextContent();
            String domain = ((OutputEntry)outputEntries.get(1)).getTextContent();
            allWorkbasketAndDomainOutputs.add((Pair<String, String>)Pair.of((Object)workbasketKey, (Object)domain));
        }
        HashSet<Pair<String, String>> hashSet3 = hashSet2 = (hashSet = allWorkbasketAndDomainOutputs);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, hashSet2);
        return hashSet;
    }

    /*
     * Unable to fully structure code
     */
    protected DmnModelInstance readModelFromDmnTable() {
        var5_1 = Factory.makeJP((JoinPoint.StaticPart)DmnTaskRouter.ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(var5_1);
        pathToDmn = (String)this.taskanaEngine.getConfiguration().getProperties().get("taskana.routing.dmn");
        var2_3 = null;
        var3_6 = null;
        stream = FileLoaderUtil.openFileFromClasspathOrSystem((String)pathToDmn, this.getClass());
        try {
            v0 = Dmn.readModelFromStream((InputStream)stream);
            ** if (stream == null) goto lbl-1000
        }
        catch (Throwable var2_4) {
            try {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    throw var2_4;
                }
                catch (Throwable var3_7) {
                    if (var2_3 == null) {
                        var2_3 = var3_7;
                    } else if (var2_3 != var3_7) {
                        var2_3.addSuppressed(var3_7);
                    }
                    throw var2_3;
                }
            }
            catch (IOException e) {
                DmnTaskRouter.LOGGER.error("caught IOException when processing dmn file {}.", (Object)pathToDmn);
                throw new SystemException("internal System error when processing dmn file " + pathToDmn, e.getCause());
            }
        }
lbl-1000:
        // 1 sources

        {
            stream.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        var6_9 = v0;
        v1 = var7_10 = v0;
        LoggingAspect.aspectOf().afterMethodExecuted(var5_1, (Object)var7_10);
        return var6_9;
    }

    private void validateOutputs(DmnModelInstance dmnModel) {
        DmnModelInstance dmnModelInstance = dmnModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)dmnModelInstance);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<Pair<String, String>> allWorkbasketAndDomainOutputs = this.getAllWorkbasketAndDomainOutputs(dmnModel);
        this.validate(allWorkbasketAndDomainOutputs);
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private void validate(Set<Pair<String, String>> allWorkbasketAndDomainOutputs) {
        Set<Pair<String, String>> set = allWorkbasketAndDomainOutputs;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, set);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketService workbasketService = this.taskanaEngine.getWorkbasketService();
        for (Pair<String, String> pair : allWorkbasketAndDomainOutputs) {
            String workbasketKey = ((String)pair.getLeft()).replace("\"", "");
            String domain = ((String)pair.getRight()).replace("\"", "");
            this.taskanaEngine.runAsAdmin(() -> {
                try {
                    return workbasketService.getWorkbasket(workbasketKey, domain);
                }
                catch (Exception e) {
                    throw new SystemException(String.format("Unknown workbasket defined in DMN Table. key: '%s', domain: '%s'", workbasketKey, domain), (Throwable)e);
                }
            });
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DmnTaskRouter.java", DmnTaskRouter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.routing.dmn.DmnTaskRouter", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "determineWorkbasketId", "pro.taskana.routing.dmn.DmnTaskRouter", "pro.taskana.task.api.models.Task", DECISION_VARIABLE_MAP_NAME, "", "java.lang.String"), 57);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getAllWorkbasketAndDomainOutputs", "pro.taskana.routing.dmn.DmnTaskRouter", "org.camunda.bpm.model.dmn.DmnModelInstance", "dmnModel", "", "java.util.Set"), 86);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "readModelFromDmnTable", "pro.taskana.routing.dmn.DmnTaskRouter", "", "", "", "org.camunda.bpm.model.dmn.DmnModelInstance"), 100);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateOutputs", "pro.taskana.routing.dmn.DmnTaskRouter", "org.camunda.bpm.model.dmn.DmnModelInstance", "dmnModel", "", "void"), 111);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validate", "pro.taskana.routing.dmn.DmnTaskRouter", "java.util.Set", "allWorkbasketAndDomainOutputs", "", "void"), 118);
    }
}

