/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.xmlrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.secure.SecureWebServer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.xmlrpc.XmlRpcComponent;
import org.codehaus.plexus.xmlrpc.XmlRpcMessageListener;

public class DefaultXmlRpcComponent
extends AbstractLogEnabled
implements Contextualizable,
Configurable,
Initializable,
Startable,
Disposable,
Serviceable,
XmlRpcComponent {
    private ServiceManager manager;
    private WebServer webserver;
    private int port;
    private boolean isSecureServer;
    private String saxParserClass;
    private boolean isStateOfParanoia;
    private Configuration handlerConfiguration;
    private Configuration[] acceptedClients;
    private Configuration[] deniedClients;
    private List listeners = new ArrayList();
    private ClassLoader classLoader;

    public void contextualize(Context context) throws ContextException {
        this.classLoader = (ClassLoader)context.get((Object)"common.classloader");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.setSystemPropertiesFromConfiguration(configuration);
        this.port = configuration.getChild("port").getValueAsInteger();
        this.getLogger().debug("Server Port: " + this.port);
        this.isSecureServer = configuration.getChild("secureServer").getValueAsBoolean();
        this.getLogger().debug("Secure Server: " + this.isSecureServer);
        this.saxParserClass = configuration.getChild("parser").getValue();
        this.isStateOfParanoia = configuration.getChild("paranoid").getValueAsBoolean();
        this.handlerConfiguration = configuration.getChild("handlers");
        this.acceptedClients = configuration.getChildren("acceptedClients");
        this.deniedClients = configuration.getChildren("deniedClients");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    void setSystemPropertiesFromConfiguration(Configuration configuration) throws ConfigurationException {
        Configuration[] systemProperties = configuration.getChildren("systemProperty");
        this.getLogger().debug("system properties: " + systemProperties.length);
        for (int i = 0; i < systemProperties.length; ++i) {
            Configuration systemProperty = systemProperties[i];
            String key = systemProperty.getAttribute("name");
            String value = systemProperty.getAttribute("value");
            this.getLogger().debug("System property: " + key + " => " + value);
            System.setProperty(key, value);
        }
    }

    public void start() throws Exception {
    }

    public void initialize() throws Exception {
        System.out.println("Attempting to start the XML-RPC server.");
        this.webserver = this.isSecureServer ? new SecureWebServer(this.port) : new WebServer(this.port);
        XmlRpc.setDriver((String)this.saxParserClass);
        this.registerStartupHandlers();
        if (this.isStateOfParanoia) {
            String clientIP;
            int i;
            this.webserver.setParanoid(this.isStateOfParanoia);
            this.getLogger().info("Operating in a state of paranoia");
            for (i = 0; i < this.acceptedClients.length; ++i) {
                Configuration acceptedClient = this.acceptedClients[i];
                clientIP = acceptedClient.getAttribute("clientIP");
                if (clientIP == null || clientIP.equals("")) continue;
                this.webserver.acceptClient(clientIP);
                this.getLogger().info("Accepting client -> " + clientIP);
            }
            for (i = 0; i < this.deniedClients.length; ++i) {
                Configuration deniedClient = this.deniedClients[i];
                clientIP = deniedClient.getAttribute("clientIP");
                if (clientIP == null || clientIP.equals("")) continue;
                this.webserver.denyClient(clientIP);
                this.getLogger().info("Accepting client -> " + clientIP);
            }
        }
    }

    private void registerStartupHandlers() throws Exception {
        Configuration[] handlers = this.handlerConfiguration.getChildren("handler");
        this.getLogger().info("We have " + handlers.length + " to configure.");
        System.out.println("We have " + handlers.length + " to configure.");
        for (int i = 0; i < handlers.length; ++i) {
            Configuration c = handlers[i];
            if (!c.getName().equals("handler")) continue;
            String handlerName = c.getChild("name").getValue();
            String handlerClass = c.getChild("class").getValue(null);
            String handlerRole = c.getChild("role").getValue(null);
            if (handlerClass != null && handlerRole == null) {
                this.registerClassHandler(handlerName, handlerClass);
                continue;
            }
            if (handlerRole != null && handlerClass == null) {
                this.registerComponentHandler(handlerName, handlerRole);
                continue;
            }
            throw new ConfigurationException("Handler must define either a 'class' or 'role'");
        }
    }

    public void stop() throws Exception {
        this.dispose();
    }

    public void dispose() {
        this.webserver.shutdown();
        try {
            Socket interrupt = new Socket(InetAddress.getLocalHost(), this.port);
            interrupt.close();
        }
        catch (Exception notShutdown) {
            this.getLogger().warn("It's possible the xmlrpc server was not shutdown: " + notShutdown.getMessage());
        }
    }

    public void registerHandler(Object handler) throws XmlRpcException, IOException {
        this.registerHandler("$default", handler);
    }

    public void registerHandler(String handlerName, Object handler) throws XmlRpcException, IOException {
        this.webserver.addHandler(handlerName, handler);
    }

    private void registerClassHandler(String handlerName, String handlerClass) throws Exception {
        try {
            Object handler = this.classLoader.loadClass(handlerClass).newInstance();
            this.webserver.addHandler(handlerName, handler);
            this.getLogger().info("registered: " + handlerName + " with class: " + handlerClass);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (OutOfMemoryError t) {
            throw t;
        }
        catch (Throwable t) {
            throw new Exception("Failed to instantiate " + handlerClass, t);
        }
    }

    private void registerComponentHandler(String handlerName, String handlerRole) throws Exception {
        this.registerHandler(handlerName, this.manager.lookup(handlerRole));
        this.getLogger().info("registered: " + handlerName + " with component: " + handlerRole);
    }

    public void unregisterHandler(String handlerName) {
        this.webserver.removeHandler(handlerName);
    }

    public Object executeRpc(URL url, String methodName, Vector params) throws Exception {
        try {
            XmlRpcClient client = new XmlRpcClient(url);
            return client.execute(methodName, params);
        }
        catch (Exception e) {
            throw new Exception("XML-RPC call failed", e);
        }
    }

    public void setParanoid(boolean state) {
        this.webserver.setParanoid(state);
    }

    public void acceptClient(String address) {
        this.webserver.acceptClient(address);
    }

    public void denyClient(String address) {
        this.webserver.denyClient(address);
    }

    public void addMessageListener(XmlRpcMessageListener listener) {
        this.listeners.add(listener);
    }

    public void messageReceived(String message) {
        System.out.println("xmlrpc: message received!");
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            XmlRpcMessageListener listener = (XmlRpcMessageListener)i.next();
            listener.xmlRpcMessageReceived(message);
        }
    }
}

