/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.builder.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.builder.AbstractBuilder;
import org.codehaus.plexus.builder.runtime.PlexusRuntimeBuilder;
import org.codehaus.plexus.builder.runtime.PlexusRuntimeBuilderException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.velocity.VelocityComponent;

public class DefaultPlexusRuntimeBuilder
extends AbstractBuilder
implements PlexusRuntimeBuilder {
    private static String JSW = "jsw";
    private static final String CLASSWORLDS_TEMPLATE = "org/codehaus/plexus/builder/templates/classworlds.vm";
    private static final String UNIX_LAUNCHER_TEMPLATE = "org/codehaus/plexus/builder/templates/plexus.vm";
    private static final String WINDOWS_LAUNCHER_TEMPLATE = "org/codehaus/plexus/builder/templates/plexus-bat.vm";
    protected VelocityComponent velocity;

    public void build(File workingDirectory, List remoteRepositories, ArtifactRepository localRepository, Set projectArtifacts, File plexusConfiguration, File configurationPropertiesFile) throws PlexusRuntimeBuilderException {
        try {
            Set coreArtifacts;
            Set bootArtifacts;
            if (workingDirectory == null) {
                throw new PlexusRuntimeBuilderException("The output directory must be specified.");
            }
            if (localRepository == null) {
                throw new PlexusRuntimeBuilderException("The local Maven repository must be specified.");
            }
            if (plexusConfiguration == null) {
                throw new PlexusRuntimeBuilderException("The plexus configuration file must be set.");
            }
            if (!plexusConfiguration.exists()) {
                throw new PlexusRuntimeBuilderException("The specified plexus configuration file '" + plexusConfiguration.getAbsolutePath() + "' doesn't exist.");
            }
            Properties configurationProperties = new Properties();
            if (configurationPropertiesFile != null) {
                configurationProperties.load(new FileInputStream(configurationPropertiesFile));
            }
            try {
                bootArtifacts = this.getBootArtifacts(projectArtifacts, remoteRepositories, localRepository, false);
                coreArtifacts = this.getCoreArtifacts(projectArtifacts, remoteRepositories, localRepository, false);
            }
            catch (ArtifactResolutionException e) {
                throw new PlexusRuntimeBuilderException("Could not resolve a artifact.", e);
            }
            this.mkdir(workingDirectory);
            this.getLogger().info("Building runtime in " + workingDirectory.getAbsolutePath());
            this.mkdir(this.getAppsDirectory(workingDirectory));
            File binDir = this.mkdir(new File(workingDirectory, "bin"));
            File confDir = this.mkdir(new File(workingDirectory, "conf"));
            File coreDir = this.mkdir(new File(workingDirectory, "core"));
            File bootDir = this.mkdir(new File(workingDirectory, "core/boot"));
            this.mkdir(new File(workingDirectory, "logs"));
            this.mkdir(new File(workingDirectory, "services"));
            this.mkdir(new File(workingDirectory, "temp"));
            this.copyArtifacts(workingDirectory, bootDir, bootArtifacts);
            this.copyArtifacts(workingDirectory, coreDir, coreArtifacts);
            this.processMainConfiguration(plexusConfiguration, configurationProperties, confDir);
            this.createSystemScripts(binDir, confDir);
            this.javaServiceWrapper(binDir, coreDir, confDir, configurationProperties);
            this.executable(new File(binDir, "plexus.sh"));
        }
        catch (PlexusRuntimeBuilderException ex) {
            throw ex;
        }
        catch (CommandLineException ex) {
            throw new PlexusRuntimeBuilderException("Exception while building the runtime.", ex);
        }
        catch (IOException ex) {
            throw new PlexusRuntimeBuilderException("Exception while building the runtime.", ex);
        }
    }

    public void bundle(File outputFile, File workingDirectory) throws PlexusRuntimeBuilderException {
        JarArchiver archiver = new JarArchiver();
        try {
            archiver.addDirectory(workingDirectory);
            archiver.setDestFile(outputFile);
            archiver.createArchive();
        }
        catch (Exception e) {
            throw new PlexusRuntimeBuilderException("Error while creating the archive.", e);
        }
    }

    public void addPlexusApplication(File plexusApplication, File runtimeDirectory) throws PlexusRuntimeBuilderException {
        try {
            FileUtils.copyFileToDirectory((File)plexusApplication, (File)this.getAppsDirectory(runtimeDirectory));
        }
        catch (IOException e) {
            throw new PlexusRuntimeBuilderException("Error while copying the application into the runtime.", e);
        }
    }

    public void addPlexusService(File plexusService, File runtimeDirectory) throws PlexusRuntimeBuilderException {
        try {
            File dir = this.getServicesDirectory(runtimeDirectory);
            String name = plexusService.getName();
            if (!name.endsWith(".jar")) {
                name = name.substring(0, name.lastIndexOf("."));
                name = name + ".jar";
            }
            FileUtils.copyFile((File)plexusService, (File)new File(dir, name));
        }
        catch (IOException e) {
            throw new PlexusRuntimeBuilderException("Error while copying the application into the runtime.", e);
        }
    }

    private File getAppsDirectory(File workingDirectory) {
        return new File(workingDirectory, "apps");
    }

    private File getServicesDirectory(File workingDirectory) {
        return new File(workingDirectory, "services");
    }

    private void createSystemScripts(File binDir, File confDir) throws PlexusRuntimeBuilderException, IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.createClassworldsConfiguration(confDir);
        this.createLauncherScripts(binDir);
        Thread.currentThread().setContextClassLoader(old);
    }

    private void createClassworldsConfiguration(File confDir) throws PlexusRuntimeBuilderException, IOException {
        this.mergeTemplate(CLASSWORLDS_TEMPLATE, new File(confDir, "classworlds.conf"));
    }

    private void createLauncherScripts(File binDir) throws PlexusRuntimeBuilderException, IOException {
        this.mergeTemplate(UNIX_LAUNCHER_TEMPLATE, new File(binDir, "plexus.sh"));
        this.mergeTemplate(WINDOWS_LAUNCHER_TEMPLATE, new File(binDir, "plexus.bat"));
    }

    private void processMainConfiguration(File plexusConfiguration, Properties configurationProperties, File confDir) throws IOException {
        File out = new File(confDir, "plexus.xml");
        this.filterCopy(plexusConfiguration, out, (Map)configurationProperties);
    }

    private void javaServiceWrapper(File binDir, File coreDir, File confDir, Properties configurationProperties) throws CommandLineException, IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        String[] linux = new String[]{"linux/libwrapper.so|x", "linux/run.sh|x", "linux/wrapper|x"};
        String[] windows = new String[]{"windows/InstallService.bat", "windows/UninstallService.bat", "windows/Wrapper.dll", "windows/Wrapper.exe", "windows/run.bat"};
        InputStream is = cl.getResourceAsStream(JSW + "/wrapper.jar");
        FileOutputStream os = new FileOutputStream(new File(coreDir + "/wrapper.jar"));
        IOUtil.copy((InputStream)is, (OutputStream)os);
        this.filterCopy(cl.getResourceAsStream(JSW + "/wrapper.conf"), new File(confDir, "wrapper.conf"), (Map)configurationProperties);
        this.copyResources(binDir, cl, linux);
        this.copyResources(binDir, cl, windows);
    }

    protected void copyResources(File dir, ClassLoader cl, String[] resources) throws CommandLineException, IOException {
        for (int i = 0; i < resources.length; ++i) {
            String instructions;
            String[] s = StringUtils.split((String)resources[i], (String)"|");
            String resource = s[0];
            InputStream is = cl.getResourceAsStream(JSW + "/" + resource);
            if (is == null) continue;
            File target = new File(dir, resource);
            this.mkdir(target.getParentFile());
            FileOutputStream os = new FileOutputStream(target);
            IOUtil.copy((InputStream)is, (OutputStream)os);
            IOUtil.close((InputStream)is);
            IOUtil.close((OutputStream)os);
            if (s.length != 2 || (instructions = s[1]).indexOf("x") < 0) continue;
            this.executable(target);
        }
    }

    protected void mergeTemplate(String templateName, File outputFileName) throws IOException, PlexusRuntimeBuilderException {
        FileWriter output = new FileWriter(outputFileName);
        try {
            this.velocity.getEngine().mergeTemplate(templateName, (Context)new VelocityContext(), (Writer)output);
        }
        catch (ResourceNotFoundException ex) {
            throw new PlexusRuntimeBuilderException("Missing Velocity template: '" + templateName + "'.", ex);
        }
        catch (Exception ex) {
            throw new PlexusRuntimeBuilderException("Exception merging the velocity template.", ex);
        }
        output.close();
    }
}

