/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.logging.log4j;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.PropertyConfigurator;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.logging.log4j.AbstractLog4JLoggerManager;
import org.codehaus.plexus.logging.log4j.Appender;
import org.codehaus.plexus.logging.log4j.Level;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;

public class Log4JLoggerManager
extends AbstractLog4JLoggerManager
implements Startable {
    private String defaultAppender;
    private List appenders;
    private List levels;
    private Properties log4JProperties;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize() throws Exception {
        super.initialize();
        this.log4JProperties = new Properties();
        HashMap<String, Object> configuredAppenders = new HashMap<String, Object>();
        if (this.appenders == null || this.appenders.size() == 0) {
            if (this.defaultAppender != null) {
                throw new PlexusConfigurationException("A default appender cant be specified without any appenders configured.");
            }
            this.defaultAppender = "anonymous";
            this.log4JProperties.setProperty("log4j.appender.anonymous", "org.apache.log4j.ConsoleAppender");
            this.log4JProperties.setProperty("log4j.appender.anonymous.threshold", this.getThresholdAsString());
            this.log4JProperties.setProperty("log4j.appender.anonymous.layout", "org.apache.log4j.PatternLayout");
            this.log4JProperties.setProperty("log4j.appender.anonymous.layout.conversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        } else {
            Object appender;
            for (int i = 0; i < this.appenders.size(); ++i) {
                appender = (Appender)this.appenders.get(i);
                String id = ((Appender)appender).getId();
                if (configuredAppenders.containsKey(id)) {
                    throw new PlexusConfigurationException("There already exists a appender with the id '" + id + "'.");
                }
                if (id == null) {
                    throw new PlexusConfigurationException("The appender must have a id.");
                }
                if (((Appender)appender).getThreshold() == null) {
                    ((Appender)appender).setThreshold(this.getThresholdAsString());
                }
                if (((Appender)appender).getConversionPattern() == null) {
                    throw new PlexusConfigurationException("The appender must have a conversion pattern.");
                }
                if (((Appender)appender).getType() == null) {
                    throw new PlexusConfigurationException("The appender must have a type.");
                }
                try {
                    Class.forName(((Appender)appender).getType());
                }
                catch (ClassNotFoundException ex) {
                    throw new PlexusConfigurationException("Could not find the appender class: " + ((Appender)appender).getType(), (Throwable)ex);
                }
                catch (LinkageError ex) {
                    throw new PlexusConfigurationException("Could load the appender class: " + ((Appender)appender).getType(), (Throwable)ex);
                }
                String base = "log4j.appender." + id;
                this.log4JProperties.setProperty(base, ((Appender)appender).getType());
                this.log4JProperties.setProperty(base + ".threshold", ((Appender)appender).getThreshold());
                this.log4JProperties.setProperty(base + ".layout", "org.apache.log4j.PatternLayout");
                this.log4JProperties.setProperty(base + ".layout.conversionPattern", ((Appender)appender).getConversionPattern());
                Enumeration e = ((Hashtable)((Appender)appender).getProperties()).keys();
                while (e.hasMoreElements()) {
                    File logFile;
                    File logDir;
                    String key = e.nextElement().toString();
                    this.log4JProperties.setProperty(base + "." + key, ((Appender)appender).getProperty(key));
                    if (!"file".equals(key) || (logDir = (logFile = new File(((Appender)appender).getProperty(key))).getParentFile()).exists()) continue;
                    logDir.mkdirs();
                }
                configuredAppenders.put(id, appender);
            }
            if (this.defaultAppender == null) {
                if (configuredAppenders.size() != 1) throw new PlexusConfigurationException("A default appender must be specified when having several appenders.");
                this.defaultAppender = ((Appender)this.appenders.get(0)).getId();
            } else {
                StringTokenizer tokenizer = new StringTokenizer(this.defaultAppender, ",");
                while (tokenizer.hasMoreTokens()) {
                    appender = tokenizer.nextToken();
                    if (configuredAppenders.containsKey(appender)) continue;
                    throw new PlexusConfigurationException("Could not find the default appender: '" + this.defaultAppender + "'.");
                }
            }
        }
        if (this.levels != null && this.levels.size() > 0) {
            Iterator it = this.levels.iterator();
            while (it.hasNext()) {
                Level level = (Level)it.next();
                ((Hashtable)this.log4JProperties).put("log4j.logger." + level.getHierarchy(), level.getLevel());
            }
        }
        if (this.getThresholdAsString() == null) {
            throw new PlexusConfigurationException("INTERNAL ERROR: The threshold must be set.");
        }
        if (this.defaultAppender == null) {
            throw new PlexusConfigurationException("INTERNAL ERROR: The default appender must be set.");
        }
        this.log4JProperties.setProperty("log4j.rootLogger", this.getThresholdAsString() + "," + this.defaultAppender);
    }

    public void start() throws Exception {
        PropertyConfigurator.configure((Properties)this.log4JProperties);
    }

    public void stop() throws Exception {
    }

    public Properties getLog4JProperties() {
        return this.log4JProperties;
    }
}

