/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.restlogger;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import pl.sparkbit.commons.restlogger.TeePrintWriter;
import pl.sparkbit.commons.restlogger.TeeServletOutputStream;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private ServletOutputStream outputStream;
    private PrintWriter printWriter;
    private final Charset charset = StandardCharsets.UTF_8;
    private boolean usingOutputStream;
    private boolean usingWriter;
    private boolean errorSent = false;

    ResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new TeeServletOutputStream((OutputStream)this.getResponse().getOutputStream(), this.buffer);
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.usingWriter = true;
        if (this.printWriter == null) {
            this.printWriter = new TeePrintWriter(this.getResponse().getWriter(), new PrintWriter(new OutputStreamWriter((OutputStream)this.buffer, this.charset)));
        }
        return this.printWriter;
    }

    String asString(String prompt) throws IOException {
        StringBuilder logBuilder = new StringBuilder(prompt).append("Outgoing response body:\n");
        ByteArrayInputStream is = new ByteArrayInputStream(this.buffer.toByteArray());
        List lines = IOUtils.readLines((InputStream)is, (Charset)this.charset);
        for (String line : lines) {
            logBuilder.append(prompt).append(line).append('\n');
        }
        return logBuilder.deleteCharAt(logBuilder.length() - 1).toString();
    }

    public void sendError(int sc, String msg2) throws IOException {
        this.errorSent = true;
        super.sendError(sc, msg2);
    }

    public void sendError(int sc) throws IOException {
        this.errorSent = true;
        super.sendError(sc);
    }

    public boolean isErrorSent() {
        return this.errorSent;
    }
}

