/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.restlogger;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import pl.sparkbit.commons.restlogger.SimpleServletInputStream;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private String log;
    private ServletInputStream sis;
    private BufferedReader bufferedReader;
    private boolean usingInputStream = false;
    private boolean usingReader = false;

    RequestWrapper(HttpServletRequest request, String prompt) throws IOException {
        super(request);
        String line;
        StringBuilder logBuilder = new StringBuilder(prompt).append("Incoming request body:\n");
        Charset charset = StandardCharsets.UTF_8;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.getRequest().getInputStream(), charset));
        StringBuilder body = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            body.append(line).append('\n');
            line = this.hidePassword(line);
            logBuilder.append(prompt).append(line).append('\n');
        }
        this.sis = new SimpleServletInputStream(new ByteArrayInputStream(body.toString().getBytes(charset)));
        this.log = logBuilder.deleteCharAt(logBuilder.length() - 1).toString();
        logBuilder.append(prompt).append('\n');
    }

    private String hidePassword(String line) {
        return line.replaceAll("\"password\"(\\s*):(\\s*)\"[^\"]*\"", "\"password\"$1:$2\"**********\"");
    }

    public ServletInputStream getInputStream() {
        if (this.usingReader) {
            throw new IllegalStateException("getReader() has already been called for this response");
        }
        this.usingInputStream = true;
        return this.sis;
    }

    public BufferedReader getReader() {
        if (this.usingInputStream) {
            throw new IllegalStateException("getInputStream() has already been called for this response");
        }
        this.usingReader = true;
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.sis, StandardCharsets.UTF_8));
        }
        return this.bufferedReader;
    }

    String asString() {
        return this.log;
    }
}

