/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.mybatis.handlers;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ZoneIdTypeHandler
extends BaseTypeHandler<ZoneId> {
    public void setNonNullParameter(PreparedStatement ps, int i, ZoneId dateTimeZone, JdbcType jdbcType) throws SQLException {
        ps.setString(i, dateTimeZone.getId());
    }

    public ZoneId getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String timeZoneId = rs.getString(columnName);
        return this.tryParseTimeZone(timeZoneId);
    }

    public ZoneId getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String timeZoneId = rs.getString(columnIndex);
        return this.tryParseTimeZone(timeZoneId);
    }

    public ZoneId getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String timeZoneId = cs.getString(columnIndex);
        return this.tryParseTimeZone(timeZoneId);
    }

    private ZoneId tryParseTimeZone(String timeZoneId) {
        if (timeZoneId == null) {
            return null;
        }
        try {
            return ZoneId.of(timeZoneId);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

