/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.mybatis.handlers;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class LocalDateTypeHandler
extends BaseTypeHandler<LocalDate> {
    public void setNonNullParameter(PreparedStatement ps, int parameterIndex, LocalDate localDate, JdbcType jdbcType) throws SQLException {
        ps.setDate(parameterIndex, Date.valueOf(localDate), Calendar.getInstance());
    }

    public LocalDate getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Date date = rs.getDate(columnName, Calendar.getInstance());
        return rs.wasNull() ? null : date.toLocalDate();
    }

    public LocalDate getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Date date = rs.getDate(columnIndex, Calendar.getInstance());
        return rs.wasNull() ? null : date.toLocalDate();
    }

    public LocalDate getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Date date = cs.getDate(columnIndex, Calendar.getInstance());
        return cs.wasNull() ? null : date.toLocalDate();
    }
}

