/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.i18n;

import jakarta.annotation.Nullable;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class Messages {
    private static final String ERROR_MESSAGE_PREFIX = "error.";
    private final MessageSource messageSource;

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, Object[] args) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(key, args, locale);
    }

    @Nullable
    public String error(String errorCode, String[] details) {
        String key = ERROR_MESSAGE_PREFIX + errorCode;
        try {
            return this.get(key, details);
        }
        catch (NoSuchMessageException e) {
            return null;
        }
    }

    public Messages(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

