/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.exception;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.sparkbit.commons.exception.RestErrorAttributes;
import pl.sparkbit.commons.exception.RestErrorProperties;
import pl.sparkbit.commons.exception.RestErrorStatusCodeResolver;
import pl.sparkbit.commons.i18n.Messages;

@Configuration
@ConditionalOnProperty(value={"sparkbit.commons.rest-error-attributes-enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={RestErrorProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\f"}, d2={"Lpl/sparkbit/commons/exception/RestErrorAutoConfiguration;", "", "()V", "restErrorAttributes", "Lpl/sparkbit/commons/exception/RestErrorAttributes;", "messages", "Lorg/springframework/beans/factory/ObjectProvider;", "Lpl/sparkbit/commons/i18n/Messages;", "restErrorProperties", "Lpl/sparkbit/commons/exception/RestErrorProperties;", "restErrorStatusCodeResolver", "Lpl/sparkbit/commons/exception/RestErrorStatusCodeResolver;", "sparkbit-commons"})
public class RestErrorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class})
    @NotNull
    public RestErrorAttributes restErrorAttributes(@NotNull ObjectProvider<Messages> messages, @NotNull RestErrorProperties restErrorProperties) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)restErrorProperties, (String)"restErrorProperties");
        return new RestErrorAttributes(messages, restErrorProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={RestErrorStatusCodeResolver.class})
    @NotNull
    public RestErrorStatusCodeResolver restErrorStatusCodeResolver() {
        return new RestErrorStatusCodeResolver();
    }
}

