/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.exception;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.IgnoredPropertyException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import pl.sparkbit.commons.exception.BusinessException;
import pl.sparkbit.commons.exception.RestErrorAttributes;
import pl.sparkbit.commons.exception.RestErrorAttributesKt;
import pl.sparkbit.commons.exception.RestErrorProperties;
import pl.sparkbit.commons.i18n.Messages;

@Order(value=-2147483648)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J(\u0010\u0012\u001a\u00020\u000b2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002J&\u0010\u0015\u001a\u00020\u000b2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u00020\u000b2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rH\u0002J(\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0006\b\u0000\u0010\u001b\u0018\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0082\b\u00a2\u0006\u0002\u0010\u001fJ&\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u00020'2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010(\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lpl/sparkbit/commons/exception/RestErrorAttributes;", "Lorg/springframework/boot/web/servlet/error/DefaultErrorAttributes;", "messagesOpt", "Lorg/springframework/beans/factory/ObjectProvider;", "Lpl/sparkbit/commons/i18n/Messages;", "restErrorProperties", "Lpl/sparkbit/commons/exception/RestErrorProperties;", "(Lorg/springframework/beans/factory/ObjectProvider;Lpl/sparkbit/commons/exception/RestErrorProperties;)V", "log", "Lmu/KLogger;", "addFieldErrors", "", "attrs", "", "", "", "exc", "", "addMessagesWithDetails", "errorAttributes", "throwable", "addStatus", "result", "status", "", "addTimestamp", "getAttribute", "T", "requestAttributes", "Lorg/springframework/web/context/request/RequestAttributes;", "name", "(Lorg/springframework/web/context/request/RequestAttributes;Ljava/lang/String;)Ljava/lang/Object;", "getErrorAttributes", "", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "opts", "Lorg/springframework/boot/web/error/ErrorAttributeOptions;", "isLoggableException", "", "isRequestAcceptJsonOrAll", "Companion", "sparkbit-commons"})
@SourceDebugExtension(value={"SMAP\nRestErrorAttributes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestErrorAttributes.kt\npl/sparkbit/commons/exception/RestErrorAttributes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n209#1,5:232\n209#1,5:237\n1549#2:242\n1620#2,3:243\n1747#2,3:246\n2624#2,3:249\n1603#2,9:252\n1855#2:261\n1856#2:263\n1612#2:264\n1549#2:265\n1620#2,3:266\n1#3:262\n*S KotlinDebug\n*F\n+ 1 RestErrorAttributes.kt\npl/sparkbit/commons/exception/RestErrorAttributes\n*L\n44#1:232,5\n58#1:237,5\n77#1:242\n77#1:243,3\n78#1:246,3\n83#1:249,3\n100#1:252,9\n100#1:261\n100#1:263\n100#1:264\n169#1:265\n169#1:266,3\n100#1:262\n*E\n"})
public final class RestErrorAttributes
extends DefaultErrorAttributes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectProvider<Messages> messagesOpt;
    @NotNull
    private final RestErrorProperties restErrorProperties;
    @NotNull
    private final KLogger log;
    @NotNull
    private static final Set<Class<?>> NOT_LOGGABLE_EXCEPTIONS;
    @NotNull
    private static final String FIELD_ERRORS = "fieldErrors";
    @NotNull
    private static final String FIELD_PATH = "path";
    @NotNull
    private static final String FIELD_ERROR_MSG = "msg";

    public RestErrorAttributes(@NotNull ObjectProvider<Messages> messagesOpt, @NotNull RestErrorProperties restErrorProperties) {
        Intrinsics.checkNotNullParameter(messagesOpt, (String)"messagesOpt");
        Intrinsics.checkNotNullParameter((Object)restErrorProperties, (String)"restErrorProperties");
        this.messagesOpt = messagesOpt;
        this.restErrorProperties = restErrorProperties;
        this.log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Object> getErrorAttributes(@NotNull WebRequest webRequest, @NotNull ErrorAttributeOptions opts) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        if (this.isRequestAcceptJsonOrAll(webRequest)) {
            void var3_3;
            Object object;
            Object object2;
            Map errorAttributes = new LinkedHashMap();
            RestErrorAttributes restErrorAttributes = this;
            Object name$iv = "jakarta.servlet.error.status_code";
            boolean $i$f$getAttribute = false;
            Object object3 = object2 = ((RequestAttributes)webRequest).getAttribute(name$iv, 0);
            if (object3 == null) {
                object = null;
            } else {
                Intrinsics.checkNotNull((Object)object3);
                Object attr$iv = object2;
                if (!(attr$iv instanceof Integer)) {
                    throw new IllegalStateException("Attribute \"" + name$iv + "\" is " + attr$iv + " (" + attr$iv.getClass() + "). Expected " + Integer.class);
                }
                object = attr$iv;
            }
            Integer n = (Integer)object;
            int status = n != null ? n : 999;
            Throwable throwable = this.getError(webRequest);
            this.addTimestamp(errorAttributes);
            this.addStatus(errorAttributes, status);
            this.addMessagesWithDetails(errorAttributes, throwable);
            this.addFieldErrors(errorAttributes, throwable);
            if (!(throwable instanceof RequestRejectedException)) {
                boolean bl = 500 <= status ? status < 600 : false;
                if (bl) {
                    Object object4;
                    Object object5;
                    name$iv = this;
                    String name$iv2 = "jakarta.servlet.error.message";
                    boolean $i$f$getAttribute2 = false;
                    Object object6 = object5 = ((RequestAttributes)webRequest).getAttribute(name$iv2, 0);
                    if (object6 == null) {
                        object4 = null;
                    } else {
                        Intrinsics.checkNotNull((Object)object6);
                        Object attr$iv = object5;
                        object4 = attr$iv;
                    }
                    Object message2 = object4;
                    this.log.error((Function0)new Function0<Object>(message2){
                        final /* synthetic */ Object $message;
                        {
                            this.$message = $message;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Runtime exception: " + this.$message;
                        }
                    });
                } else if (!(400 <= status ? status < 500 : false) && this.isLoggableException(throwable)) {
                    this.log.error("Runtime exception", throwable);
                }
            }
            map = var3_3;
        } else {
            Map map2 = super.getErrorAttributes(webRequest, opts);
            Intrinsics.checkNotNull((Object)map2);
            map = map2;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRequestAcceptJsonOrAll(WebRequest webRequest) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            String accept = webRequest.getHeader("accept");
            if (accept == null || StringsKt.isBlank((CharSequence)accept)) {
                return true;
            }
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)accept, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(MediaType.valueOf((String)((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MediaType it = (MediaType)element$iv;
                    boolean bl3 = false;
                    if (!it.isCompatibleWith(MediaType.APPLICATION_JSON)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isLoggableException(Throwable throwable) {
        boolean bl;
        block5: {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                Throwable instance = throwable2;
                boolean bl2 = false;
                Iterable $this$none$iv = NOT_LOGGABLE_EXCEPTIONS;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Class it = (Class)element$iv;
                        boolean bl3 = false;
                        if (!it.isInstance(instance)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMessagesWithDetails(Map<String, Object> errorAttributes, Throwable throwable) {
        String message2;
        Object object;
        Object object2;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof BusinessException) {
            errorAttributes.put("errorCode", ((BusinessException)throwable).getErrorCode());
            this.messagesOpt.ifAvailable(arg_0 -> RestErrorAttributes.addMessagesWithDetails$lambda$4(errorAttributes, throwable, arg_0));
            Map<String, Object> additionalErrorDetails = ((BusinessException)throwable).getAdditionalErrorDetails();
            if (additionalErrorDetails != null) {
                errorAttributes.put("errorDetails", additionalErrorDetails);
            }
            object2 = ((BusinessException)throwable).getMessage();
        } else if (throwable2 instanceof BindException) {
            void $this$mapNotNullTo$iv$iv;
            List list = ((BindException)throwable).getBindingResult().getAllErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllErrors(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ObjectError it = (ObjectError)element$iv$iv;
                boolean bl2 = false;
                if (it.getDefaultMessage() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            object2 = !((Collection)it).isEmpty() ? CollectionsKt.joinToString$default((Iterable)it, (CharSequence)"\n- ", (CharSequence)"Validation errors:\n- ", null, (int)0, null, null, (int)60, null) : "Validation failed";
        } else if (throwable2 instanceof HttpMessageNotReadableException) {
            Throwable cause = ((HttpMessageNotReadableException)throwable).getCause();
            if (cause instanceof InvalidFormatException) {
                if (((InvalidFormatException)cause).getTargetType().isEnum()) {
                    Object object3 = ((InvalidFormatException)cause).getValue();
                    Object[] objectArray = ((InvalidFormatException)cause).getTargetType().getEnumConstants();
                    Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getEnumConstants(...)");
                    object2 = "Invalid value \"" + object3 + "\". Correct values are: " + ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, (Function1)addMessagesWithDetails.message.4.INSTANCE, (int)31, null);
                } else {
                    object2 = "Invalid value \"" + ((InvalidFormatException)cause).getValue() + "\"";
                }
            } else if (cause instanceof UnrecognizedPropertyException) {
                object2 = "Unrecognized property \"" + ((UnrecognizedPropertyException)cause).getPropertyName() + "\"";
            } else if (cause instanceof IgnoredPropertyException) {
                object2 = "Invalid property \"" + ((IgnoredPropertyException)cause).getPropertyName() + "\"";
            } else if (cause instanceof InvalidTypeIdException) {
                object2 = "Invalid object type \"" + ((InvalidTypeIdException)cause).getTypeId() + "\"";
            } else if (cause instanceof MismatchedInputException) {
                object2 = "Invalid JSON payload";
            } else if (cause instanceof JsonParseException) {
                object2 = "JSON payload is not well formatted";
            } else if (cause instanceof JsonMappingException) {
                if (((JsonMappingException)cause).getPath().isEmpty()) {
                    object2 = null;
                } else {
                    List list = ((JsonMappingException)cause).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPath(...)");
                    object2 = "Invalid value in field \"" + RestErrorAttributesKt.access$asStr(list) + "\"";
                }
            } else {
                object2 = null;
            }
        } else {
            object2 = throwable2 instanceof MissingServletRequestParameterException ? "Missing request parameter: " + ((MissingServletRequestParameterException)throwable).getParameterName() : (throwable2 instanceof MissingServletRequestPartException ? "Missing request part: " + ((MissingServletRequestPartException)throwable).getRequestPartName() : (throwable2 instanceof RequestRejectedException ? "The request was rejected because requests contains malicious URL, parameters or payload" : (throwable2 instanceof MaxUploadSizeExceededException ? "Upload exceeds the maximum upload size allowed" : (throwable2 instanceof MultipartException ? "Invalid multipart request" : null))));
        }
        if ((object = (message2 = object2)) == null) {
            object = "Unknown error";
        }
        errorAttributes.put("message", object);
        if (this.restErrorProperties.getIncludeStacktraceForErrors()) {
            Throwable throwable3 = throwable;
            errorAttributes.put("stacktrace", throwable3 != null ? ExceptionsKt.stackTraceToString((Throwable)throwable3) : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addFieldErrors(Map<String, Object> attrs, Throwable exc) {
        if (exc == null) {
            return;
        }
        Throwable throwable = exc;
        if (throwable instanceof BindException) {
            void $this$mapTo$iv$iv;
            Map<String, Object> map = attrs;
            String string = FIELD_ERRORS;
            List list = ((BindException)exc).getBindingResult().getFieldErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFieldErrors(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FieldError fieldError = (FieldError)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)FIELD_PATH, (Object)it.getField()), TuplesKt.to((Object)FIELD_ERROR_MSG, (Object)it.getDefaultMessage())};
                collection.add(MapsKt.mapOf((Pair[])pairArray));
            }
            List list2 = (List)destination$iv$iv;
            map.put(string, list2);
        } else if (throwable instanceof HttpMessageNotReadableException) {
            Throwable cause = ((HttpMessageNotReadableException)exc).getCause();
            if (cause instanceof InvalidFormatException) {
                String string;
                if (((InvalidFormatException)cause).getTargetType().isEnum()) {
                    Object object = ((InvalidFormatException)cause).getValue();
                    Object[] objectArray = ((InvalidFormatException)cause).getTargetType().getEnumConstants();
                    Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getEnumConstants(...)");
                    string = "invalid value \"" + object + "\", valid are: " + ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, (Function1)addFieldErrors.msg.1.INSTANCE, (int)31, null);
                } else {
                    string = "invalid value \"" + ((InvalidFormatException)cause).getValue() + "\"";
                }
                String msg2 = string;
                List list = ((InvalidFormatException)cause).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPath(...)");
                if (!((Collection)list).isEmpty()) {
                    Map<String, Object> map = attrs;
                    String string2 = FIELD_ERRORS;
                    Object object = new Pair[2];
                    List list3 = ((InvalidFormatException)cause).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getPath(...)");
                    object[0] = TuplesKt.to((Object)FIELD_PATH, (Object)RestErrorAttributesKt.access$asStr(list3));
                    object[1] = TuplesKt.to((Object)FIELD_ERROR_MSG, (Object)msg2);
                    object = CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])object));
                    map.put(string2, object);
                }
            } else if (cause instanceof UnrecognizedPropertyException) {
                List list = ((UnrecognizedPropertyException)cause).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPath(...)");
                if (!((Collection)list).isEmpty()) {
                    Map<String, Object> map = attrs;
                    String string = FIELD_ERRORS;
                    Object object = new Pair[2];
                    List list4 = ((UnrecognizedPropertyException)cause).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getPath(...)");
                    object[0] = TuplesKt.to((Object)FIELD_PATH, (Object)RestErrorAttributesKt.access$asStr(list4));
                    object[1] = TuplesKt.to((Object)FIELD_ERROR_MSG, (Object)"unrecognized property");
                    object = CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])object));
                    map.put(string, object);
                }
            } else if (cause instanceof JsonMappingException) {
                List list = ((JsonMappingException)cause).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPath(...)");
                if (!((Collection)list).isEmpty()) {
                    Map<String, Object> map = attrs;
                    String string = FIELD_ERRORS;
                    Object object = new Pair[2];
                    List list5 = ((JsonMappingException)cause).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getPath(...)");
                    object[0] = TuplesKt.to((Object)FIELD_PATH, (Object)RestErrorAttributesKt.access$asStr(list5));
                    object[1] = TuplesKt.to((Object)FIELD_ERROR_MSG, (Object)"invalid");
                    object = CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])object));
                    map.put(string, object);
                }
            }
        }
    }

    private final void addTimestamp(Map<String, Object> result) {
        result.put("timestamp", Instant.now().toEpochMilli());
    }

    private final void addStatus(Map<String, Object> result, int status) {
        Integer n = status;
        result.put("status", n);
    }

    private final /* synthetic */ <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        boolean $i$f$getAttribute = false;
        Object object = requestAttributes.getAttribute(name, 0);
        if (object == null) {
            return null;
        }
        Object attr = object;
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (!(attr instanceof Object)) {
            Class<?> clazz = attr.getClass();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new IllegalStateException("Attribute \"" + name + "\" is " + attr + " (" + clazz + "). Expected " + Object.class);
        }
        return (T)attr;
    }

    private static final void addMessagesWithDetails$lambda$4(Map $errorAttributes, Throwable $throwable, Messages messages) {
        Intrinsics.checkNotNullParameter((Object)$errorAttributes, (String)"$errorAttributes");
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        $errorAttributes.put("translatedMessage", messages.error(((BusinessException)$throwable).getErrorCode(), ((BusinessException)$throwable).getMessageDetails()));
    }

    static {
        Object[] objectArray = new Class[]{TypeMismatchException.class, MethodArgumentNotValidException.class, AccessDeniedException.class};
        NOT_LOGGABLE_EXCEPTIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lpl/sparkbit/commons/exception/RestErrorAttributes$Companion;", "", "()V", "FIELD_ERRORS", "", "FIELD_ERROR_MSG", "FIELD_PATH", "NOT_LOGGABLE_EXCEPTIONS", "", "Ljava/lang/Class;", "sparkbit-commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

