/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.exception;

import java.util.Arrays;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.BAD_REQUEST)
public class BusinessException
extends RuntimeException {
    private static final String DEFAULT_ERROR_CODE = "BUSINESS_RULES_VIOLATED";
    private final String errorCode;
    private final String[] messageDetails;

    public BusinessException(String message2) {
        this(message2, DEFAULT_ERROR_CODE);
    }

    public BusinessException(String message2, String errorCode) {
        this(message2, errorCode, (String[])null);
    }

    public BusinessException(String message2, String ... messageDetails) {
        this(message2, DEFAULT_ERROR_CODE, messageDetails);
    }

    public BusinessException(String message2, String errorCode, String ... messageDetails) {
        super(message2);
        this.errorCode = errorCode;
        this.messageDetails = messageDetails;
    }

    public String[] getMessageDetails() {
        return this.messageDetails != null ? Arrays.copyOf(this.messageDetails, this.messageDetails.length) : new String[]{};
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    protected Map<String, Object> getAdditionalErrorDetails() {
        return null;
    }
}

