/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.util;

import com.github.ziplet.filter.compression.CompressingFilter;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.sparkbit.commons.util.ContentCompressionProperties;

@Configuration
@EnableConfigurationProperties(value={ContentCompressionProperties.class})
@ConditionalOnProperty(value={"sparkbit.commons.content-compression.enabled"}, havingValue="true", matchIfMissing=true)
public class ContentCompressionAutoConfiguration {
    private final ContentCompressionProperties configuration;

    @Bean
    public FilterRegistrationBean<CompressingFilter> compressingFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.compressingFilter());
        String threshold = String.valueOf(this.configuration.getThreshold());
        registration.addInitParameter("compressionThreshold", threshold);
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean
    public CompressingFilter compressingFilter() {
        return new CompressingFilter();
    }

    public ContentCompressionAutoConfiguration(ContentCompressionProperties configuration) {
        this.configuration = configuration;
    }
}

