/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.test.redis;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.testcontainers.containers.ContainerState;
import pl.sparkbit.commons.test.redis.RedisContainer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0017R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lpl/sparkbit/commons/test/redis/RedisTestConfigBase;", "", "()V", "redisExposedPort", "", "Ljava/lang/Integer;", "redisImage", "", "redisContainerState", "Lorg/testcontainers/containers/ContainerState;", "testConnectionFactory", "Lorg/springframework/data/redis/connection/RedisConnectionFactory;", "containerState", "Companion", "sparkbit-commons"})
public class RedisTestConfigBase {
    @Value(value="${redis-test.image:redis:5.0.8-alpine}")
    private final String redisImage;
    @Value(value="${redis-test.exposed-port:6379}")
    private final Integer redisExposedPort;
    private static final String TEST_REDIS_IMAGE = "redis-test.image";
    private static final String TEST_REDIS_EXPOSED_PORT = "redis-test.exposed-port";
    public static final Companion Companion = new Companion(null);

    @Bean
    @NotNull
    public ContainerState redisContainerState() {
        String string = this.redisImage;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        RedisContainer redis = (RedisContainer)new RedisContainer(string).withExposedPorts(new Integer[]{this.redisExposedPort});
        redis.start();
        RedisContainer redisContainer = redis;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)redisContainer), (String)"redis");
        return (ContainerState)redisContainer;
    }

    @Bean
    @NotNull
    public RedisConnectionFactory testConnectionFactory(@NotNull ContainerState containerState) {
        Intrinsics.checkParameterIsNotNull((Object)containerState, (String)"containerState");
        String string = containerState.getContainerIpAddress();
        Integer n = containerState.getFirstMappedPort();
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"containerState.firstMappedPort");
        return (RedisConnectionFactory)new JedisConnectionFactory(new RedisStandaloneConfiguration(string, n.intValue()));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lpl/sparkbit/commons/test/redis/RedisTestConfigBase$Companion;", "", "()V", "TEST_REDIS_EXPOSED_PORT", "", "TEST_REDIS_IMAGE", "sparkbit-commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

