/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.test.mysql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Arrays;
import javax.sql.DataSource;
import net.sf.log4jdbc.sql.jdbcapi.DataSourceSpy;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.transaction.PlatformTransactionManager;

public class MapperTestConfigBase {
    private static final String TEST_DB_PREFIX = "mapper-test.db.";
    private static final String TEST_DB_HANDLER_PACKAGES = "mapper-test.db.handler-packages";
    private static final String TEST_DB_SCHEMA_FILES = "mapper-test.db.schema-files";
    private static final String TEST_DB_TYPE_ALIASES_PACKAGE = "mapper-test.db.type-aliases-package";
    private static final String TEST_DB_MYSQL_VERSION = "mapper-test.db.mysql.version";
    private static final String TEST_DB_MYSQL_CONFIG_DIR = "mapper-test.db.mysql.config-dir";
    @Value(value="classpath*:mybatis/*-mapper.xml")
    private Resource[] mappers;
    @Value(value="${mapper-test.db.schema-files:}")
    private String[] schemaFiles;
    @Value(value="${mapper-test.db.handler-packages:}")
    private String handlerPackages;
    @Value(value="${mapper-test.db.type-aliases-package:}")
    private String typeAliasesPackage;
    @Value(value="${mapper-test.db.mysql.version:5.7}")
    private String mysqlVersion;
    @Value(value="${mapper-test.db.mysql.config-dir:#{null}}")
    private String mysqlConfigDir;

    @Bean
    public DataSource dataSourceSpied() {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName("org.testcontainers.jdbc.ContainerDatabaseDriver");
        String jdbcUrl = "jdbc:tc:mysql:" + this.mysqlVersion + "://localhost/dbname?TC_TMPFS=/var/lib/mysql:rw";
        if (this.mysqlConfigDir != null) {
            jdbcUrl = jdbcUrl + "&TC_MY_CNF=" + this.mysqlConfigDir;
        }
        config.setMaximumPoolSize(1);
        config.setJdbcUrl(jdbcUrl);
        return new HikariDataSource(config);
    }

    @Bean
    public DataSource dataSource(DataSource dataSourceSpied) {
        return new DataSourceSpy(dataSourceSpied);
    }

    @Bean
    public DataSourceInitializer dataSourceInitializer(DataSource dataSource) {
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer();
        dataSourceInitializer.setDataSource(dataSource);
        dataSourceInitializer.setDatabasePopulator(this.databasePopulator());
        dataSourceInitializer.setDatabaseCleaner(connection -> {});
        return dataSourceInitializer;
    }

    private DatabasePopulator databasePopulator() {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        Arrays.stream(this.schemaFiles).forEach(file -> populator.addScript((Resource)new ClassPathResource(file)));
        return populator;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setMapperLocations(this.mappers);
        sessionFactory.setTypeAliasesPackage(this.typeAliasesPackage);
        sessionFactory.setTypeHandlersPackage("pl.sparkbit.commons.mybatis.handlers," + this.handlerPackages);
        return sessionFactory.getObject();
    }

    @Bean
    public PlatformTransactionManager txManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

