/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.test.cassandra;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.cassandra.config.AbstractCassandraConfiguration;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.ContainerState;
import pl.sparkbit.commons.test.cassandra.CassandraTestConfigBase;
import pl.sparkbit.commons.test.cassandra.KCassandraContainer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\u0004H\u0014J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0016\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0014J\b\u0010\u0010\u001a\u00020\u0004H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\t\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/sparkbit/commons/test/cassandra/CassandraTestConfigBase;", "Lorg/springframework/data/cassandra/config/AbstractCassandraConfiguration;", "()V", "basePackage", "", "cassandraImage", "initScripts", "", "[Ljava/lang/String;", "keyspace", "cassandraContainerState", "Lorg/testcontainers/containers/ContainerState;", "getContactPoints", "getEntityBasePackages", "()[Ljava/lang/String;", "getKeyspaceName", "getLocalDataCenter", "getPort", "", "getStartupScripts", "", "metersRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "prepareStartupScript", "", "text", "Companion", "sparkbit-commons"})
public class CassandraTestConfigBase
extends AbstractCassandraConfiguration {
    @Value(value="${cassandra-test.image:cassandra:3.11}")
    private final String cassandraImage;
    @Value(value="${cassandra-test.keyspace}")
    private final String keyspace;
    @Value(value="${cassandra-test.base-package}")
    private final String basePackage;
    @Value(value="${cassandra-test.init-scripts:}")
    private final String[] initScripts;
    private static final String TEST_CASSANDRA_IMAGE = "cassandra-test.image";
    @NotNull
    public static final String TEST_CASSANDRA_KEYSPACE = "cassandra-test.keyspace";
    private static final String TEST_CASSANDRA_BASE_PACKAGE = "cassandra-test.base-package";
    private static final String TEST_CASSANDRA_INIT_SCRIPTS = "cassandra-test.init-scripts";
    public static final Companion Companion = new Companion(null);

    @Bean
    @NotNull
    public ContainerState cassandraContainerState() {
        String string = this.cassandraImage;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        KCassandraContainer cassandra = (KCassandraContainer)((KCassandraContainer)((KCassandraContainer)new KCassandraContainer(string).withInitScript("cassandra_keyspace.cql")).withTmpFs(MapsKt.mapOf((Pair)TuplesKt.to((Object)"/var/lib/cassandra", (Object)"rw")))).withEnv("JVM_OPTS", "-Dcassandra.skip_wait_for_gossip_to_settle=0 -Xmx384M -Xms384M");
        cassandra.start();
        KCassandraContainer kCassandraContainer = cassandra;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kCassandraContainer), (String)"cassandra");
        return (ContainerState)kCassandraContainer;
    }

    @NotNull
    protected String getContactPoints() {
        String string = this.cassandraContainerState().getContainerIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cassandraContainerState().containerIpAddress");
        return string;
    }

    protected int getPort() {
        ContainerState containerState = this.cassandraContainerState();
        Integer n = CassandraContainer.CQL_PORT;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"CassandraContainer.CQL_PORT");
        Integer n2 = containerState.getMappedPort(n.intValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"cassandraContainerState(\u2026sandraContainer.CQL_PORT)");
        return n2;
    }

    @Nullable
    protected String getKeyspaceName() {
        return this.keyspace;
    }

    @NotNull
    public String[] getEntityBasePackages() {
        String[] stringArray;
        if (this.basePackage != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.basePackage;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @NotNull
    protected String getLocalDataCenter() {
        return "datacenter1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<String> getStartupScripts() {
        boolean bl = false;
        List result = new ArrayList();
        String[] $this$forEach$iv = this.initScripts;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String script = element$iv = stringArray[i];
            boolean bl2 = false;
            InputStream inputStream = new ClassPathResource(script).getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"ClassPathResource(script).inputStream");
            Closeable closeable = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl3 = false;
            Object object = closeable;
            int n2 = 0;
            object = new InputStreamReader((InputStream)object, charset);
            n2 = 8192;
            boolean bl4 = false;
            closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n2);
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl6 = false;
                object = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object text = object;
            List<String> lines = this.prepareStartupScript((String)text);
            result.addAll((Collection)lines);
        }
        return result;
    }

    private final List<String> prepareStartupScript(String text) {
        prepareStartupScript.1 $fun$removeEmptyLines$1 = prepareStartupScript.1.INSTANCE;
        prepareStartupScript.2 $fun$removeNewLineIfNotAfterSemicolon$2 = prepareStartupScript.2.INSTANCE;
        prepareStartupScript.3 $fun$removeTrailingNewLine$3 = prepareStartupScript.3.INSTANCE;
        return StringsKt.lines((CharSequence)$fun$removeTrailingNewLine$3.invoke($fun$removeNewLineIfNotAfterSemicolon$2.invoke($fun$removeEmptyLines$1.invoke(text))));
    }

    @Bean
    @NotNull
    public MeterRegistry metersRegistry() {
        return (MeterRegistry)new SimpleMeterRegistry();
    }

    public CassandraTestConfigBase() {
        CassandraTestConfigBase cassandraTestConfigBase = this;
        String[] stringArray = new String[]{};
        cassandraTestConfigBase.initScripts = stringArray;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lpl/sparkbit/commons/test/cassandra/CassandraTestConfigBase$Companion;", "", "()V", "TEST_CASSANDRA_BASE_PACKAGE", "", "TEST_CASSANDRA_IMAGE", "TEST_CASSANDRA_INIT_SCRIPTS", "TEST_CASSANDRA_KEYSPACE", "sparkbit-commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

