/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.restlogger;

import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.sparkbit.commons.restlogger.RestLoggerProperties;
import pl.sparkbit.commons.restlogger.RestLoggingFilter;

@ConditionalOnProperty(value={"sparkbit.commons.rest-logger.enabled"}, havingValue="true", matchIfMissing=true)
@Configuration
@EnableConfigurationProperties(value={RestLoggerProperties.class})
public class RestLoggingFilterAutoConfiguration {
    private static final int RIGHT_AFTER_HIGHEST_PRECEDENCE = -2147483647;

    @Bean
    public FilterRegistrationBean<RestLoggingFilter> requestLoggingFilterRegistration(RestLoggingFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)filter);
        registration.setOrder(-2147483647);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ERROR});
        return registration;
    }

    @Bean
    public RestLoggingFilter requestLoggingFilter(RestLoggerProperties properties) {
        return new RestLoggingFilter(properties.getExcludeUrlPatterns());
    }
}

