/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.restlogger;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import pl.sparkbit.commons.restlogger.RequestWrapper;
import pl.sparkbit.commons.restlogger.ResponseWrapper;

public class RestLoggingFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger((String)"restlogger");
    private static final String REQUEST_ID_ATTRIBUTE = "logging.requestId";
    private final AtomicLong id = new AtomicLong(0L);
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final List<String> excludeUrlPatterns;

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        long requestId = this.getRequestId(request);
        if (log.isTraceEnabled()) {
            if (this.shouldLogRequest(request)) {
                request = this.logRequest(requestId, request);
            }
            ResponseWrapper responseWrapper = new ResponseWrapper(response);
            chain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
            if (this.shouldLogResponse(request, responseWrapper)) {
                this.logResponse(requestId, request, (HttpServletResponse)responseWrapper);
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        return this.excludeUrlPatterns.stream().anyMatch(p -> this.pathMatcher.match(p, request.getServletPath()));
    }

    private long getRequestId(HttpServletRequest request) {
        if (request.getAttribute(REQUEST_ID_ATTRIBUTE) != null) {
            return (Long)request.getAttribute(REQUEST_ID_ATTRIBUTE);
        }
        long requestId = this.id.incrementAndGet();
        request.setAttribute(REQUEST_ID_ATTRIBUTE, (Object)requestId);
        return requestId;
    }

    private boolean shouldLogRequest(HttpServletRequest request) {
        return request.getDispatcherType() == DispatcherType.REQUEST;
    }

    private HttpServletRequest logRequest(long requestId, HttpServletRequest request) throws IOException {
        log.trace("{} Incoming request headers \n{}", (Object)this.inPrompt(requestId), (Object)this.getHeaders(requestId, (HttpServletRequest)request));
        try {
            if (request.getContentType() != null && MediaType.valueOf((String)request.getContentType()).isCompatibleWith(MediaType.APPLICATION_JSON)) {
                request = new RequestWrapper((HttpServletRequest)request, this.inPrompt(requestId));
                log.trace(((RequestWrapper)((Object)request)).asString());
            }
        }
        catch (InvalidMediaTypeException e) {
            log.trace("Request has invalid Content-Type!");
        }
        return request;
    }

    private boolean shouldLogResponse(HttpServletRequest request, ResponseWrapper responseWrapper) {
        if (request.getDispatcherType() == DispatcherType.ERROR) {
            return true;
        }
        return !responseWrapper.isErrorSent();
    }

    private void logResponse(long requestId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.trace("{} Outgoing response headers (possibly not all included): \n{}", (Object)this.outPrompt(requestId), (Object)this.getHeaders(requestId, response, request.getProtocol()));
        if (response.getContentType() != null && MediaType.valueOf((String)response.getContentType()).isCompatibleWith(MediaType.APPLICATION_JSON)) {
            log.trace(((ResponseWrapper)response).asString(this.outPrompt(requestId)));
        }
    }

    private String getHeaders(long requestId, HttpServletRequest request) {
        String prompt = this.inPrompt(requestId);
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append(prompt).append(request.getMethod()).append(' ').append(request.getRequestURI());
        if (request.getQueryString() != null) {
            logBuilder.append('?').append(request.getQueryString());
        }
        logBuilder.append(' ').append(request.getProtocol()).append('\n');
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            logBuilder.append(prompt).append(headerName).append(" : ").append(request.getHeader(headerName)).append('\n');
        }
        return logBuilder.deleteCharAt(logBuilder.length() - 1).toString();
    }

    private String getHeaders(long requestId, HttpServletResponse response, String protocol) {
        String prompt = this.outPrompt(requestId);
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append(prompt).append(protocol).append(' ').append(response.getStatus()).append(' ').append(HttpStatus.valueOf((int)response.getStatus()).name()).append('\n');
        Collection headerNames = response.getHeaderNames();
        for (String headerName : headerNames) {
            logBuilder.append(prompt).append(headerName).append(" : ").append(response.getHeader(headerName)).append('\n');
        }
        return logBuilder.deleteCharAt(logBuilder.length() - 1).toString();
    }

    private String outPrompt(long requestId) {
        return requestId + " <== ";
    }

    private String inPrompt(long requestId) {
        return requestId + " ==> ";
    }

    public RestLoggingFilter(List<String> excludeUrlPatterns) {
        this.excludeUrlPatterns = excludeUrlPatterns;
    }
}

