/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.time.Instant;

public class InstantFromMillisDeserializer
extends StdScalarDeserializer<Instant> {
    public InstantFromMillisDeserializer() {
        super(Instant.class);
    }

    public Instant deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        String s;
        if (jp.getCurrentToken() != JsonToken.VALUE_NUMBER_INT) {
            deserializationContext.reportWrongTokenException(Instant.class, JsonToken.VALUE_NUMBER_INT, "expected integer", new Object[0]);
        }
        if ((s = jp.getText().trim()).length() == 0) {
            return null;
        }
        long millis = Long.parseLong(s);
        return Instant.ofEpochMilli(millis);
    }
}

