/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.exception;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.context.request.WebRequest;
import pl.sparkbit.commons.exception.BusinessException;
import pl.sparkbit.commons.i18n.Messages;

public class RestErrorAttributes
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(RestErrorAttributes.class);
    private static final Set<Class<?>> NOT_LOGGABLE_EXCEPTIONS = ImmutableSet.of(TypeMismatchException.class, MethodArgumentNotValidException.class, AccessDeniedException.class);
    private final ObjectProvider<Messages> messagesOpt;

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, ErrorAttributeOptions opts) {
        String contentType = webRequest.getHeader("content-type");
        if (contentType != null && MediaType.valueOf((String)contentType).isCompatibleWith(MediaType.APPLICATION_JSON)) {
            Map errorAttributes = super.getErrorAttributes(webRequest, opts.isIncluded(ErrorAttributeOptions.Include.STACK_TRACE));
            this.removeUnwantedAttributes(errorAttributes);
            this.changeTimestampToMillis(errorAttributes);
            Throwable throwable = this.getError(webRequest);
            if (throwable == null) {
                if (HttpStatus.valueOf((int)((Integer)errorAttributes.get("status"))).is5xxServerError()) {
                    log.error("Runtime exception: {}", errorAttributes.get("message"));
                }
            } else if (throwable instanceof BusinessException) {
                BusinessException businessException = (BusinessException)throwable;
                errorAttributes.put("errorCode", businessException.getErrorCode());
                this.messagesOpt.ifAvailable(messages -> errorAttributes.put("translatedMessage", messages.error(businessException.getErrorCode(), businessException.getMessageDetails())));
                Map<String, Object> additionalErrorDetails = businessException.getAdditionalErrorDetails();
                if (additionalErrorDetails != null) {
                    errorAttributes.put("errorDetails", additionalErrorDetails);
                }
            } else if (NOT_LOGGABLE_EXCEPTIONS.stream().noneMatch(nlec -> nlec.isInstance(throwable))) {
                log.error("Runtime exception", throwable);
            }
            return errorAttributes;
        }
        return super.getErrorAttributes(webRequest, opts);
    }

    private void removeUnwantedAttributes(Map<String, Object> result) {
        result.remove("exception");
        result.remove("error");
    }

    private void changeTimestampToMillis(Map<String, Object> result) {
        result.put("timestamp", Instant.now().toEpochMilli());
    }

    public RestErrorAttributes(ObjectProvider<Messages> messagesOpt) {
        this.messagesOpt = messagesOpt;
    }
}

