/*
 * Decompiled with CFR 0.152.
 */
package pl.metaprogramming.model.oas;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import pl.metaprogramming.model.oas.OpenapiParserConfig;
import pl.metaprogramming.model.oas.RestApi;
import pl.metaprogramming.model.oas.RestApiBuilder;
import pl.metaprogramming.model.oas.parser.BaseParser;
import pl.metaprogramming.model.oas.parser.DefinitionsParser;
import pl.metaprogramming.model.oas.parser.EnumParser;
import pl.metaprogramming.model.oas.parser.JsonYamlParser;
import pl.metaprogramming.model.oas.parser.Oas2OperationsParser;
import pl.metaprogramming.model.oas.parser.Oas3OperationsParser;
import pl.metaprogramming.model.oas.parser.OperationsParser;
import pl.metaprogramming.model.oas.parser.ParametersParser;

public class OpenapiParser
extends BaseParser {
    private OasVersion version;
    private DefinitionsParser definitionsParser;
    private ParametersParser parametersParser;
    private OperationsParser operationsParser;
    private EnumParser enumParser;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public OpenapiParser(Map spec, OpenapiParserConfig config) {
        Map map = spec;
        this.setSpec(map);
        OpenapiParserConfig openapiParserConfig = config;
        this.setConfig(openapiParserConfig);
    }

    public static RestApi parse(String filepath) {
        return OpenapiParser.parse(filepath, StandardCharsets.UTF_8);
    }

    public static RestApi parse(String filepath, Charset charset) {
        return OpenapiParser.parse(filepath, charset, new OpenapiParserConfig());
    }

    public static RestApi parse(String filepath, OpenapiParserConfig config) {
        return OpenapiParser.parse(filepath, StandardCharsets.UTF_8, config);
    }

    public static RestApi parse(String filepath, Charset charset, OpenapiParserConfig config) {
        return new OpenapiParser(JsonYamlParser.read(new File(filepath), charset), config).read();
    }

    public static RestApi parse(String openApiContent, RestApi ... dependencies) {
        boolean isJson = openApiContent.startsWith("{");
        Map model = isJson ? JsonYamlParser.readJson(openApiContent) : JsonYamlParser.readYaml(openApiContent);
        OpenapiParserConfig openapiParserConfig = new OpenapiParserConfig();
        List<Object> list = Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)dependencies, Object[].class));
        openapiParserConfig.setDependsOn(list);
        OpenapiParserConfig config = openapiParserConfig;
        return new OpenapiParser(model, config).read();
    }

    public RestApi read() {
        this.setup();
        this.definitionsParser.readDefinitions();
        this.parametersParser.readParameters();
        this.operationsParser.readOperations();
        this.enumParser.addEnums();
        return this.getBuilder().getModel();
    }

    public Object getWarnings() {
        return this.getBuilder().getChecker().getWarnings();
    }

    public void setup() {
        OperationsParser operationsParser;
        ParametersParser parametersParser;
        DefinitionsParser definitionsParser;
        EnumParser enumParser;
        this.readVersion();
        this.setupBuilder();
        this.readInfo();
        this.enumParser = enumParser = new EnumParser(this);
        this.definitionsParser = definitionsParser = new DefinitionsParser(this, this.enumParser);
        this.parametersParser = parametersParser = new ParametersParser(this, this.definitionsParser);
        this.operationsParser = operationsParser = this.makeOperationsParser().setup(this, this.definitionsParser, this.parametersParser);
    }

    public void readVersion() {
        if (ScriptBytecodeAdapter.compareEqual(this.getSpec().get("swagger"), (Object)"2.0") || this.isPartialOas2()) {
            OasVersion oasVersion;
            BaseParser.Oas2ParsingStrategy oas2ParsingStrategy = new BaseParser.Oas2ParsingStrategy();
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)oas2ParsingStrategy, OpenapiParser.class, (GroovyObject)this, (String)"verParsingStrategy");
            this.version = oasVersion = OasVersion.OAS2;
        } else {
            String string = (String)ScriptBytecodeAdapter.asType(this.getSpec().get("openapi"), String.class);
            if (DefaultTypeTransformation.booleanUnbox(string != null ? Boolean.valueOf(string.startsWith("3.0")) : null) || this.isPartialOas3()) {
                OasVersion oasVersion;
                BaseParser.Oas3ParsingStrategy oas3ParsingStrategy = new BaseParser.Oas3ParsingStrategy();
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)oas3ParsingStrategy, OpenapiParser.class, (GroovyObject)this, (String)"verParsingStrategy");
                this.version = oasVersion = OasVersion.OAS3;
            } else {
                throw (Throwable)new IllegalArgumentException("The API specification is neither Swagger 2.0 nor OpenAPI 3.0.x");
            }
        }
    }

    public void setupBuilder() {
        RestApiBuilder restApiBuilder = new RestApiBuilder(ScriptBytecodeAdapter.compareEqual((Object)((Object)this.version), (Object)((Object)OasVersion.OAS2)));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)restApiBuilder, OpenapiParser.class, (GroovyObject)this, (String)"builder");
        this.getBuilder().dependsOn(this.getConfig().getDependsOn());
        boolean bl = this.getConfig().getWeekValidation();
        this.getBuilder().getChecker().setWeekValidation(bl);
    }

    public void readInfo() {
        if (this.getSpec().get("info") instanceof Map) {
            Map info = (Map)ScriptBytecodeAdapter.asType(this.getSpec().get("info"), Map.class);
            Object v = info.get("version");
            this.getBuilder().getModel().setVersion(ShortTypeHandling.castToString(v));
            Object v2 = info.get("title");
            this.getBuilder().getModel().setTitle(ShortTypeHandling.castToString(v2));
        }
    }

    public boolean isPartialOas2() {
        return this.getConfig().getPartialFile() && (DefaultTypeTransformation.booleanUnbox(this.getSpec().get("schemas")) || DefaultTypeTransformation.booleanUnbox(this.getSpec().get("parameters")));
    }

    public boolean isPartialOas3() {
        return this.getConfig().getPartialFile() && DefaultTypeTransformation.booleanUnbox(this.getSpec().get("components"));
    }

    private OperationsParser makeOperationsParser() {
        return ScriptBytecodeAdapter.compareEqual((Object)((Object)this.version), (Object)((Object)OasVersion.OAS3)) ? new Oas3OperationsParser() : new Oas2OperationsParser();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(OpenapiParser.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(OpenapiParser.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(OpenapiParser.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, OpenapiParser.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(OpenapiParser.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OpenapiParser.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static final class OasVersion
    extends Enum<OasVersion>
    implements GroovyObject {
        public static final /* enum */ OasVersion OAS2;
        public static final /* enum */ OasVersion OAS3;
        public static final OasVersion MIN_VALUE;
        public static final OasVersion MAX_VALUE;
        private static final /* synthetic */ OasVersion[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        private OasVersion(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum pl.metaprogramming.model.oas.OpenapiParser$OasVersion was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        private OasVersion() {
            this(new LinkedHashMap());
        }

        @Generated
        public static final OasVersion[] values() {
            return (OasVersion[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), OasVersion[].class);
        }

        @Generated
        public OasVersion next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (OasVersion)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), OasVersion.class);
        }

        @Generated
        public OasVersion previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (OasVersion)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), OasVersion.class);
        }

        @Generated
        public static OasVersion valueOf(String name) {
            return (OasVersion)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(OasVersion.class, name)), OasVersion.class);
        }

        @Generated
        public static final /* synthetic */ OasVersion $INIT(Object ... para) {
            OasVersion oasVersion;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, OasVersion.class)) {
                case -1348271900: {
                    OasVersion oasVersion2;
                    oasVersion = oasVersion2;
                    Object[] objectArray2 = objectArray;
                    oasVersion2 = new OasVersion();
                    break;
                }
                case -242181752: {
                    OasVersion oasVersion2;
                    oasVersion = oasVersion2;
                    Object[] objectArray2 = objectArray;
                    oasVersion2 = new OasVersion((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return oasVersion;
        }

        static {
            OasVersion oasVersion;
            OasVersion oasVersion2;
            OasVersion oasVersion3;
            OasVersion oasVersion4;
            OAS2 = oasVersion4 = OasVersion.$INIT("OAS2", 0);
            OAS3 = oasVersion3 = OasVersion.$INIT("OAS3", 1);
            MIN_VALUE = oasVersion2 = OAS2;
            MAX_VALUE = oasVersion = OAS3;
            OasVersion[] oasVersionArray = new OasVersion[]{OAS2, OAS3};
            $VALUES = oasVersionArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != OasVersion.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

