/*
 * Decompiled with CFR 0.152.
 */
package pl.metaprogramming.model.data.constraint;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.metaprogramming.model.data.constraint.CheckerRef;
import pl.metaprogramming.model.data.constraint.ConditionConstraint;
import pl.metaprogramming.model.data.constraint.Constraints;
import pl.metaprogramming.model.data.constraint.DataConstraint;
import pl.metaprogramming.model.data.constraint.DictionaryConstraint;
import pl.metaprogramming.model.data.constraint.RuleConstraint;
import pl.metaprogramming.model.data.constraint.ValidationDirective;
import pl.metaprogramming.model.data.constraint.ValidatorPointer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018J,\u0010\u0011\u001a\u00020\u0012*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\bH\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/metaprogramming/model/data/constraint/ConstraintsSupport;", "", "additives", "", "(Ljava/util/Map;)V", "getAdditives", "()Ljava/util/Map;", "value", "", "invalidPatternCode", "getInvalidPatternCode", "()Ljava/lang/String;", "setInvalidPatternCode", "(Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "add", "", "constraint", "Lpl/metaprogramming/model/data/constraint/DataConstraint;", "", "element", "getConstraints", "", "key", "Collector", "codegen"})
public final class ConstraintsSupport {
    @NotNull
    private final Map<Object, Object> additives;
    private final Logger log;

    public ConstraintsSupport(@NotNull Map<Object, Object> additives) {
        Intrinsics.checkNotNullParameter(additives, (String)"additives");
        this.additives = additives;
        this.log = LoggerFactory.getLogger(ConstraintsSupport.class);
    }

    @NotNull
    public final Map<Object, Object> getAdditives() {
        return this.additives;
    }

    @Nullable
    public final String getInvalidPatternCode() {
        for (Object it : this.getAdditives("x-constraints")) {
            if (!(it instanceof Map) || !((Map)it).containsKey("invalid-pattern-code")) continue;
            Object v = ((Map)it).get("invalid-pattern-code");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return (String)v;
        }
        return null;
    }

    public final void setInvalidPatternCode(@Nullable String value) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"invalid-pattern-code", (Object)value)};
        this.getAdditives("x-constraints").add(MapsKt.mutableMapOf((Pair[])pairArray));
    }

    public final void add(@NotNull DataConstraint constraint) {
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        Map spec = new LinkedHashMap();
        if (constraint instanceof RuleConstraint) {
            spec.put("rule", ((RuleConstraint)constraint).getRuleCode());
        }
        if (constraint instanceof DictionaryConstraint) {
            spec.put("dictionary", ((DictionaryConstraint)constraint).getDictionaryCode());
        }
        if (constraint instanceof ConditionConstraint) {
            spec.put("condition", ((ConditionConstraint)constraint).getExpression());
        }
        if (constraint instanceof CheckerRef) {
            spec.put("checker-class", ((CheckerRef)constraint).getClassName());
            this.add(spec, ((CheckerRef)constraint).getStaticField(), "checker-static-field");
            this.add(spec, ((CheckerRef)constraint).getMethodRef(), "checker-method-ref");
        }
        this.add(spec, constraint.getErrorCode(), "error-code");
        this.add(spec, constraint.getPriority(), "priority");
        this.getAdditives("x-constraints").add(spec);
    }

    private final void add(Map<String, Object> $this$add, Object value, String key) {
        if (value != null) {
            $this$add.put(key, value);
        }
    }

    @NotNull
    public final List<DataConstraint> getConstraints() {
        return new Collector().collect();
    }

    private final List<Object> getAdditives(String element) {
        if (this.additives.get(element) == null) {
            Map<Object, Object> map = this.additives;
            List list = new ArrayList();
            map.put(element, list);
        }
        Object object = this.additives.get(element);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
        }
        return TypeIntrinsics.asMutableList((Object)object);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0001H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lpl/metaprogramming/model/data/constraint/ConstraintsSupport$Collector;", "", "(Lpl/metaprogramming/model/data/constraint/ConstraintsSupport;)V", "result", "", "Lpl/metaprogramming/model/data/constraint/DataConstraint;", "getResult", "()Ljava/util/List;", "addConstraint", "", "spec", "addValidation", "collect", "", "makeConstraint", "codegen"})
    private final class Collector {
        @NotNull
        private final List<DataConstraint> result;

        public Collector() {
            Intrinsics.checkNotNullParameter((Object)ConstraintsSupport.this, (String)"this$0");
            this.result = new ArrayList();
        }

        @NotNull
        public final List<DataConstraint> getResult() {
            return this.result;
        }

        @NotNull
        public final List<DataConstraint> collect() {
            Object p0;
            Object element$iv;
            Iterable $this$forEach$iv = ConstraintsSupport.this.getAdditives("x-validations");
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                p0 = element$iv = iterator.next();
                boolean bl = false;
                this.addValidation(p0);
            }
            $this$forEach$iv = ConstraintsSupport.this.getAdditives("x-constraints");
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                p0 = element$iv = iterator.next();
                boolean bl = false;
                this.addConstraint(p0);
            }
            int priority = 0;
            priority = 100;
            Iterable $this$forEach$iv2 = this.result;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DataConstraint it = (DataConstraint)element$iv2;
                boolean bl = false;
                if (it.getPriority() != null) continue;
                it.setPriority(++priority);
            }
            return this.result;
        }

        private final void addValidation(Object spec) {
            if (spec instanceof String) {
                if (StringsKt.startsWith$default((String)((String)spec), (String)"compare:", (boolean)false, (int)2, null)) {
                    String string = ((String)spec).substring("compare:".length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    this.result.add(new ConditionConstraint(string));
                } else {
                    this.result.add(new ValidationDirective(ValidatorPointer.Companion.fromExpression((String)spec)));
                }
            } else {
                ConstraintsSupport.this.log.error(Intrinsics.stringPlus((String)"Can't handle 'x-validations': ", (Object)spec));
            }
        }

        private final void addConstraint(Object spec) {
            DataConstraint constraint = this.makeConstraint(spec);
            if (constraint != null && spec instanceof Map) {
                constraint.setErrorCode((String)((Map)spec).get("error-code"));
                constraint.setPriority((Integer)((Map)spec).get("priority"));
                this.result.add(constraint);
            } else {
                ConstraintsSupport.this.log.error(Intrinsics.stringPlus((String)"Can't handle 'x-constraints': ", (Object)spec));
            }
        }

        private final DataConstraint makeConstraint(Object spec) {
            if (spec instanceof Map) {
                if (((Map)spec).containsKey("rule")) {
                    Object v = ((Map)spec).get("rule");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    return Constraints.Companion.rule((String)v);
                }
                if (((Map)spec).containsKey("dictionary")) {
                    Object v = ((Map)spec).get("dictionary");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    return Constraints.Companion.dictionary((String)v);
                }
                if (((Map)spec).containsKey("condition")) {
                    Object v = ((Map)spec).get("condition");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    return Constraints.Companion.condition((String)v);
                }
                if (((Map)spec).containsKey("checker-class")) {
                    Object v = ((Map)spec).get("checker-class");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    String string = (String)v;
                    String string2 = (String)((Map)spec).get("checker-static-field");
                    String string3 = (String)((Map)spec).get("checker-method-ref");
                    return new CheckerRef(string, string3, string2);
                }
            }
            return null;
        }
    }
}

