/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.metamodel.data

abstract class NamedDataType extends DataType {
    String code

    protected NamedDataType(DataTypeCode typeCode) {
        super(typeCode)
    }

    DataSchema makeSchema() {
        makeSchema(code)
    }

    String toString() {
        return "${typeCode.toString()}[${code}]"
    }
}
