package pl.metaprogramming.metamodel.data

import pl.metaprogramming.metamodel.data.constraints.Constraints

import java.util.function.Consumer
import java.util.function.Supplier

class DataSchema {

    /**
     * Nazwa kodowa danych.
     */
    String code

    /**
     * Namespace (xsd).
     * Raczej powinien być przeniesiony do DateType
     */
    String namespace

    /**
     * Flaga określająca czy dane są wymagane.
     */
    boolean isRequired = false

    /**
     * Typ danych.
     */
    DataType dataType

    String defaultValue

    /**
     *  Dotyczy pola DATE_TIME
     */
    String format

    /**
     * Dotyczy pola tekstowego - wyrażenie regularne.
     */
    String pattern

    /**
     * Dotyczy pola tekstowego - min/max długość
     */
    Integer minLength
    Integer maxLength

    /**
     * Dotyczy pola liczbowego
     */
    String minimum
    String maximum

    /**
     * Dotyczy xsd
     */
    boolean isNillable

    Map additives = [:]

    final Constraints constraints = new Constraints(this)

    DataType getBaseDataType() {
        if (isArray()) {
            arrayType.itemsSchema.baseDataType
        } else {
            dataType
        }
    }

    String toString() {
        ToString.toString(this)
    }

    boolean isType(DataTypeCode... typeCodes) {
        typeCodes.any { dataType.is(it) }
    }

    boolean isTypeOrItemType(DataTypeCode... typeCodes) {
        typeCodes.any { dataType.isTypeOrItemType(it) }
    }

    boolean isEnum() {
        dataType.isEnum()
    }

    boolean isObject() {
        dataType.isObject()
    }

    boolean isArray() {
        dataType.isArray()
    }

    boolean isMap() {
        dataType.isMap()
    }

    boolean isBinary() {
        dataType.binary
    }

    boolean isEnumOrItemEnum() {
        dataType.enumOrItemEnum
    }

    EnumType getEnumType() {
        dataType.enumType
    }

    ObjectType getObjectType() {
        dataType.objectType
    }

    ArrayType getArrayType() {
        dataType.arrayType
    }

    MapType getMapType() {
        dataType.mapType
    }

    String getFormat() {
        if (dataType instanceof ArrayType) {
            dataType.itemsSchema.format
        } else {
            this.format
        }
    }

    String getDescription() {
        additives.description ?: isObject() ? getObjectType().description : null
    }

    void setAdditive(String key, Object value) {
        additives.put(key, value)
    }

    void setAdditiveIfNotSet(String key, Supplier<Object> value) {
        if (!additives.containsKey(key)) {
            setAdditive(key, value.get())
        }
    }

    void addAdditiveItems(String key, Object...items) {
        setAdditiveIfNotSet(key) { [] }
        (additives[key] as List).addAll(Arrays.asList(items))
    }

    String getAdditive(String key, boolean required = true) {
        if (required && !additives.containsKey(key)) {
            throw new IllegalStateException("No '$key' attribute found in data schema '${toString()}' - $additives")
        }
        additives.get(key)
    }

    String getQname() {
        "{$namespace}$code"
    }

    DataSchema constraints(Consumer<Constraints> updater) {
        updater.accept(constraints)
        this
    }

}
