/*
 * Copyright (c) 2021 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.model.java.index

import groovy.transform.EqualsAndHashCode
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.builder.java.MethodCmBuilder
import pl.metaprogramming.codemodel.model.java.MethodCm

class MapperEntry {

    MethodCmBuilder builder
    ClassEntry ownerClass
    MethodCm externalMethod
    private boolean used
    private boolean built

    @Lazy
    Key key = new Key(to: methodCm.resultType, from: methodCm.params.collect { it.type })

    void markAsUsed() {
        used = true
        if (ownerClass) {
            ownerClass.markAsUsed()
        }
    }

    boolean isToMake() {
        !built && builder && (used || !builder.generateIfUsed)
    }

    void makeImplementation() {
        built = true
        builder.makeImplementation()
    }

    MethodCm getMethodCm() {
        externalMethod ?: builder.methodCm
    }

    @EqualsAndHashCode
    static class Key {
        ClassCd to
        List<ClassCd> from

        @Override
        String toString() {
            "($from) -> $to"
        }
    }
}
