/*
 * Copyright (c) 2018,2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.model.java

/**
 * Represents literals or field/params references
 */
class ValueCm {
    List<String> value
    boolean escaped
    boolean array
    boolean itemPerLine

    static ValueCm escaped(String value) {
        new ValueCm(value: [value], escaped: true)
    }

    static ValueCm value(String value) {
        new ValueCm(value: [value])
    }

    static ValueCm escapedArray(List<String> values) {
        new ValueCm(value: values, array: true, escaped: true)
    }

    static ValueCm array(List<String> values) {
        new ValueCm(value: values, array: true)
    }

    @Override
    String toString() {
        if (array) {
            "{${value.collect { escaped ? escapedString(it) : it}.join(', ')}}"
        } else {
            escaped ? escapedString(value[0]) : value[0]
        }
    }

    private static String escapedString(def value) {
        value != null ? "\"${value}\"" : 'null'
    }
}
