/*
 * Copyright (c) 2018,2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.model.java


import groovy.transform.ToString
import groovy.transform.builder.Builder
import groovy.transform.builder.SimpleStrategy

import static pl.metaprogramming.codemodel.model.java.JavaDefs.MODIFIER_PUBLIC
import static pl.metaprogramming.codemodel.model.java.JavaDefs.MODIFIER_STATIC

@ToString(includePackage = false, includes = ['name', 'resultType', 'params'])
@Builder(builderStrategy = SimpleStrategy)
class MethodCm {
    ClassCm ownerClass
    String name
    ClassCd resultType
    List<FieldCm> params
    List<AnnotationCm> annotations = []
    String implBody
    List<ClassCd> implDependencies
    String description

    String modifiers = MODIFIER_PUBLIC

    void collectDependencies(Collection<ClassCd> dependencies) {
        resultType?.collectDependencies(dependencies)
        params?.each { it.collectDependencies(dependencies) }
        annotations.each { it.collectDependencies(dependencies) }
        implDependencies?.each { it.collectDependencies(dependencies) }
    }

    boolean isConstructor() {
        name == ownerClass.className
    }

    boolean isPublic() {
        modifiers && modifiers.contains(MODIFIER_PUBLIC)
    }

    boolean isStatic() {
        modifiers && modifiers.contains(MODIFIER_STATIC)
    }

    boolean matchNameAndParams(MethodCm methodCm) {
        name == methodCm.name && paramTypes == methodCm.paramTypes
    }

    List<ClassCd> getParamTypes() {
        params.collect { it.type }
    }

    MethodCm addParam(String name, ClassCd type) {
        if (params == null) params = []
        params.add(new FieldCm(type, name))
        this
    }
}
