/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.model.java

interface JavaDefs {

    String T_COLLECTION        = 'java.util.Collection'
    String T_LIST              = 'java.util.List'
    String T_MAP               = 'java.util.Map'
    String T_HASH_MAP          = 'java.util.HashMap'
    String FUN                 = 'java.util.function.Function'
    String OPTIONAL            = 'java.util.Optional'

    String MODIFIER_PUBLIC               = 'public'
    String MODIFIER_PUBLIC_STATIC        = 'public static'
    String MODIFIER_PUBLIC_ABSTRACT      = 'public abstract'
    String MODIFIER_PRIVATE              = 'private'
    String MODIFIER_PRIVATE_FINAL        = 'private final'
    String MODIFIER_PRIVATE_STATIC_FINAL = 'private static final'
    String MODIFIER_PROTECTED            = 'protected'
    String MODIFIER_DEFAULT              = 'default'
    String MODIFIER_STATIC               = 'static'

    ClassCd T_OBJECT           = new ClassCd('java.lang.Object')
    ClassCd T_STRING           = new ClassCd('java.lang.String')
    ClassCd T_BOOLEAN          = new ClassCd('java.lang.Boolean')
    ClassCd T_BOOLEAN_PRIMITIVE= new ClassCd('boolean')
    ClassCd T_LONG             = new ClassCd('java.lang.Long')
    ClassCd T_INTEGER          = new ClassCd('java.lang.Integer')
    ClassCd T_INT_PRIMITIVE    = new ClassCd('int')
    ClassCd T_BYTE             = new ClassCd('java.lang.Byte')
    ClassCd T_SHORT            = new ClassCd('java.lang.Short')
    ClassCd T_FLOAT            = new ClassCd('java.lang.Float')
    ClassCd T_DOUBLE           = new ClassCd('java.lang.Double')
    ClassCd T_DATE             = new ClassCd('java.util.Date')
    ClassCd T_LOCAL_DATE       = new ClassCd('java.time.LocalDate')
    ClassCd T_LOCAL_DATE_TIME  = new ClassCd('java.time.LocalDateTime')
    ClassCd T_ZONED_DATE_TIME  = new ClassCd('java.time.ZonedDateTime')
    ClassCd T_BIG_DECIMAL      = new ClassCd('java.math.BigDecimal')
    ClassCd T_BYTE_ARRAY       = new ClassCd(className: 'byte', isArray: true)
    ClassCd T_URI              = new ClassCd('java.net.URI')
    ClassCd T_STREAM_COLLECTORS= new ClassCd('java.util.stream.Collectors')

    ClassCd I_SERIALIZABLE     = new ClassCd('java.io.Serializable')

    ClassCd GENERIC_K          = ClassCd.genericParam('K')
    ClassCd GENERIC_R          = ClassCd.genericParam('R')
    ClassCd GENERIC_V          = ClassCd.genericParam('V')
    ClassCd GENERIC_T          = ClassCd.genericParam('T')
    ClassCd GENERIC_ANY        = ClassCd.genericParam('?')
    ClassCd CLASS_T            = new ClassCd('java.lang.Class', [GENERIC_T])
    ClassCd FUN_T_R            = new ClassCd(FUN, [GENERIC_T, GENERIC_R])
    ClassCd LIST_R             = new ClassCd(T_LIST, [GENERIC_R])
    ClassCd LIST_T             = new ClassCd(T_LIST, [GENERIC_T])
    ClassCd MAP_KR             = new ClassCd(T_MAP, [GENERIC_K, GENERIC_R])
    ClassCd MAP_KT             = new ClassCd(T_MAP, [GENERIC_K, GENERIC_T])
    ClassCd LIST_ANONYMOUS     = new ClassCd(T_LIST)
    ClassCd COLLECTION_OF_INT  = new ClassCd(T_COLLECTION, [T_INTEGER])


    ClassCd COLLECTIONS        = new ClassCd('java.util.Collections')
    ClassCd ARRAYS             = new ClassCd('java.util.Arrays')
    ClassCd OBJECTS            = new ClassCd('java.util.Objects')

    AnnotationCm ANNOT_LB_DATA = new AnnotationCm('lombok.Data')
    AnnotationCm ANNOT_LB_GETTER = new AnnotationCm('lombok.Getter')
    AnnotationCm ANNOT_LB_NO_ARGS_CONTR = new AnnotationCm('lombok.NoArgsConstructor')
    AnnotationCm ANNOT_LB_ALL_ARGS_CONTR = new AnnotationCm('lombok.AllArgsConstructor')
    AnnotationCm ANNOT_LB_REQUIRED_ARGS_CONTR = new AnnotationCm('lombok.RequiredArgsConstructor')
    AnnotationCm ANNOT_LB_ACCESSORS = new AnnotationCm('lombok.experimental.Accessors', [chain: ValueCm.value('true')])
    AnnotationCm ANNOT_LB_EQ_AND_HC = new AnnotationCm('lombok.EqualsAndHashCode', [callSuper: ValueCm.value('true')])
    AnnotationCm ANNOT_LB_BUILDER = new AnnotationCm('lombok.Builder')
    AnnotationCm ANNOT_LB_VALUE = new AnnotationCm('lombok.Value')
    AnnotationCm ANNOT_SLF4J = new AnnotationCm('lombok.extern.slf4j.Slf4j')
    AnnotationCm ANNOT_NON_NULL = new AnnotationCm('javax.annotation.Nonnull')
    AnnotationCm ANNOT_NULLABLE = new AnnotationCm('javax.annotation.Nullable')
    AnnotationCm ANNOT_PARAMETERS_ARE_NONNULL_BY_DEFAULT = new AnnotationCm('javax.annotation.ParametersAreNonnullByDefault')
    AnnotationCm ANNOT_OVERRIDE = new AnnotationCm('java.lang.Override')
    AnnotationCm ANNOT_SUPPRESS_UNCHECKED = new AnnotationCm('java.lang.SuppressWarnings', [value: ValueCm.escaped('unchecked')])

    interface Validation {
        AnnotationCm VALID = new AnnotationCm('javax.validation.Valid')
        AnnotationCm NOT_NULL = new AnnotationCm('javax.validation.constraints.NotNull')
    }

    interface Jackson {
        AnnotationCm JSON_VALUE = new AnnotationCm('com.fasterxml.jackson.annotation.JsonValue')
    }
}
